/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.CreateUsageLimitRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateUsageLimitRequestMarshaller
implements Marshaller<Request<CreateUsageLimitRequest>, CreateUsageLimitRequest> {
    public Request<CreateUsageLimitRequest> marshall(CreateUsageLimitRequest createUsageLimitRequest) {
        if (createUsageLimitRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUsageLimitRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateUsageLimit");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUsageLimitRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)createUsageLimitRequest.getClusterIdentifier()));
        }
        if (createUsageLimitRequest.getFeatureType() != null) {
            request.addParameter("FeatureType", StringUtils.fromString((String)createUsageLimitRequest.getFeatureType()));
        }
        if (createUsageLimitRequest.getLimitType() != null) {
            request.addParameter("LimitType", StringUtils.fromString((String)createUsageLimitRequest.getLimitType()));
        }
        if (createUsageLimitRequest.getAmount() != null) {
            request.addParameter("Amount", StringUtils.fromLong((Long)createUsageLimitRequest.getAmount()));
        }
        if (createUsageLimitRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromString((String)createUsageLimitRequest.getPeriod()));
        }
        if (createUsageLimitRequest.getBreachAction() != null) {
            request.addParameter("BreachAction", StringUtils.fromString((String)createUsageLimitRequest.getBreachAction()));
        }
        if (!createUsageLimitRequest.getTags().isEmpty() || !((SdkInternalList)createUsageLimitRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createUsageLimitRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

