/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.Image;
import java.io.Serializable;

public class CompareFacesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Image sourceImage;
    private Image targetImage;
    private Float similarityThreshold;

    public void setSourceImage(Image sourceImage) {
        this.sourceImage = sourceImage;
    }

    public Image getSourceImage() {
        return this.sourceImage;
    }

    public CompareFacesRequest withSourceImage(Image sourceImage) {
        this.setSourceImage(sourceImage);
        return this;
    }

    public void setTargetImage(Image targetImage) {
        this.targetImage = targetImage;
    }

    public Image getTargetImage() {
        return this.targetImage;
    }

    public CompareFacesRequest withTargetImage(Image targetImage) {
        this.setTargetImage(targetImage);
        return this;
    }

    public void setSimilarityThreshold(Float similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public Float getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public CompareFacesRequest withSimilarityThreshold(Float similarityThreshold) {
        this.setSimilarityThreshold(similarityThreshold);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceImage() != null) {
            sb.append("SourceImage: ").append(this.getSourceImage()).append(",");
        }
        if (this.getTargetImage() != null) {
            sb.append("TargetImage: ").append(this.getTargetImage()).append(",");
        }
        if (this.getSimilarityThreshold() != null) {
            sb.append("SimilarityThreshold: ").append(this.getSimilarityThreshold());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest)obj;
        if (other.getSourceImage() == null ^ this.getSourceImage() == null) {
            return false;
        }
        if (other.getSourceImage() != null && !other.getSourceImage().equals(this.getSourceImage())) {
            return false;
        }
        if (other.getTargetImage() == null ^ this.getTargetImage() == null) {
            return false;
        }
        if (other.getTargetImage() != null && !other.getTargetImage().equals(this.getTargetImage())) {
            return false;
        }
        if (other.getSimilarityThreshold() == null ^ this.getSimilarityThreshold() == null) {
            return false;
        }
        return other.getSimilarityThreshold() == null || other.getSimilarityThreshold().equals(this.getSimilarityThreshold());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceImage() == null ? 0 : this.getSourceImage().hashCode());
        hashCode = 31 * hashCode + (this.getTargetImage() == null ? 0 : this.getTargetImage().hashCode());
        hashCode = 31 * hashCode + (this.getSimilarityThreshold() == null ? 0 : this.getSimilarityThreshold().hashCode());
        return hashCode;
    }

    public CompareFacesRequest clone() {
        return (CompareFacesRequest)super.clone();
    }
}

