/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.DetectLabelsImageBackground;
import com.amazonaws.services.rekognition.model.DetectLabelsImageForeground;
import com.amazonaws.services.rekognition.model.DetectLabelsImageQuality;
import com.amazonaws.services.rekognition.model.DominantColor;
import com.amazonaws.services.rekognition.model.transform.DetectLabelsImagePropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectLabelsImageProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private DetectLabelsImageQuality quality;
    private List<DominantColor> dominantColors;
    private DetectLabelsImageForeground foreground;
    private DetectLabelsImageBackground background;

    public void setQuality(DetectLabelsImageQuality quality) {
        this.quality = quality;
    }

    public DetectLabelsImageQuality getQuality() {
        return this.quality;
    }

    public DetectLabelsImageProperties withQuality(DetectLabelsImageQuality quality) {
        this.setQuality(quality);
        return this;
    }

    public List<DominantColor> getDominantColors() {
        return this.dominantColors;
    }

    public void setDominantColors(Collection<DominantColor> dominantColors) {
        if (dominantColors == null) {
            this.dominantColors = null;
            return;
        }
        this.dominantColors = new ArrayList<DominantColor>(dominantColors);
    }

    public DetectLabelsImageProperties withDominantColors(DominantColor ... dominantColors) {
        if (this.dominantColors == null) {
            this.setDominantColors(new ArrayList<DominantColor>(dominantColors.length));
        }
        for (DominantColor ele : dominantColors) {
            this.dominantColors.add(ele);
        }
        return this;
    }

    public DetectLabelsImageProperties withDominantColors(Collection<DominantColor> dominantColors) {
        this.setDominantColors(dominantColors);
        return this;
    }

    public void setForeground(DetectLabelsImageForeground foreground) {
        this.foreground = foreground;
    }

    public DetectLabelsImageForeground getForeground() {
        return this.foreground;
    }

    public DetectLabelsImageProperties withForeground(DetectLabelsImageForeground foreground) {
        this.setForeground(foreground);
        return this;
    }

    public void setBackground(DetectLabelsImageBackground background) {
        this.background = background;
    }

    public DetectLabelsImageBackground getBackground() {
        return this.background;
    }

    public DetectLabelsImageProperties withBackground(DetectLabelsImageBackground background) {
        this.setBackground(background);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuality() != null) {
            sb.append("Quality: ").append(this.getQuality()).append(",");
        }
        if (this.getDominantColors() != null) {
            sb.append("DominantColors: ").append(this.getDominantColors()).append(",");
        }
        if (this.getForeground() != null) {
            sb.append("Foreground: ").append(this.getForeground()).append(",");
        }
        if (this.getBackground() != null) {
            sb.append("Background: ").append(this.getBackground());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsImageProperties)) {
            return false;
        }
        DetectLabelsImageProperties other = (DetectLabelsImageProperties)obj;
        if (other.getQuality() == null ^ this.getQuality() == null) {
            return false;
        }
        if (other.getQuality() != null && !other.getQuality().equals(this.getQuality())) {
            return false;
        }
        if (other.getDominantColors() == null ^ this.getDominantColors() == null) {
            return false;
        }
        if (other.getDominantColors() != null && !other.getDominantColors().equals(this.getDominantColors())) {
            return false;
        }
        if (other.getForeground() == null ^ this.getForeground() == null) {
            return false;
        }
        if (other.getForeground() != null && !other.getForeground().equals(this.getForeground())) {
            return false;
        }
        if (other.getBackground() == null ^ this.getBackground() == null) {
            return false;
        }
        return other.getBackground() == null || other.getBackground().equals(this.getBackground());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuality() == null ? 0 : this.getQuality().hashCode());
        hashCode = 31 * hashCode + (this.getDominantColors() == null ? 0 : this.getDominantColors().hashCode());
        hashCode = 31 * hashCode + (this.getForeground() == null ? 0 : this.getForeground().hashCode());
        hashCode = 31 * hashCode + (this.getBackground() == null ? 0 : this.getBackground().hashCode());
        return hashCode;
    }

    public DetectLabelsImageProperties clone() {
        try {
            return (DetectLabelsImageProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DetectLabelsImagePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

