/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.AudioMetadata;

@SdkInternalApi
public class AudioMetadataMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Codec").build();
    private static final MarshallingInfo<Long> DURATIONMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationMillis").build();
    private static final MarshallingInfo<Long> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleRate").build();
    private static final MarshallingInfo<Long> NUMBEROFCHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfChannels").build();
    private static final AudioMetadataMarshaller instance = new AudioMetadataMarshaller();

    public static AudioMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(AudioMetadata audioMetadata, ProtocolMarshaller protocolMarshaller) {
        if (audioMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioMetadata.getCodec(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)audioMetadata.getDurationMillis(), DURATIONMILLIS_BINDING);
            protocolMarshaller.marshall((Object)audioMetadata.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)audioMetadata.getNumberOfChannels(), NUMBEROFCHANNELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

