/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.robomaker.model.RobotSoftwareSuite;
import com.amazonaws.services.robomaker.model.Source;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateRobotApplicationResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String arn;
    private String name;
    private String version;
    private List<Source> sources;
    private RobotSoftwareSuite robotSoftwareSuite;
    private Date lastUpdatedAt;
    private String revisionId;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public CreateRobotApplicationResult withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRobotApplicationResult withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CreateRobotApplicationResult withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(Collection<Source> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<Source>(sources);
    }

    public CreateRobotApplicationResult withSources(Source ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<Source>(sources.length));
        }
        for (Source ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public CreateRobotApplicationResult withSources(Collection<Source> sources) {
        this.setSources(sources);
        return this;
    }

    public void setRobotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
        this.robotSoftwareSuite = robotSoftwareSuite;
    }

    public RobotSoftwareSuite getRobotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public CreateRobotApplicationResult withRobotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
        this.setRobotSoftwareSuite(robotSoftwareSuite);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public CreateRobotApplicationResult withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public CreateRobotApplicationResult withRevisionId(String revisionId) {
        this.setRevisionId(revisionId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateRobotApplicationResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateRobotApplicationResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateRobotApplicationResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getRobotSoftwareSuite() != null) {
            sb.append("RobotSoftwareSuite: ").append(this.getRobotSoftwareSuite()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getRevisionId() != null) {
            sb.append("RevisionId: ").append(this.getRevisionId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotApplicationResult)) {
            return false;
        }
        CreateRobotApplicationResult other = (CreateRobotApplicationResult)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getRobotSoftwareSuite() == null ^ this.getRobotSoftwareSuite() == null) {
            return false;
        }
        if (other.getRobotSoftwareSuite() != null && !other.getRobotSoftwareSuite().equals(this.getRobotSoftwareSuite())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getRevisionId() == null ^ this.getRevisionId() == null) {
            return false;
        }
        if (other.getRevisionId() != null && !other.getRevisionId().equals(this.getRevisionId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getRobotSoftwareSuite() == null ? 0 : this.getRobotSoftwareSuite().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getRevisionId() == null ? 0 : this.getRevisionId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRobotApplicationResult clone() {
        try {
            return (CreateRobotApplicationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

