/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.Compute;
import com.amazonaws.services.robomaker.model.DataSourceConfig;
import com.amazonaws.services.robomaker.model.FailureBehavior;
import com.amazonaws.services.robomaker.model.LoggingConfig;
import com.amazonaws.services.robomaker.model.OutputLocation;
import com.amazonaws.services.robomaker.model.RobotApplicationConfig;
import com.amazonaws.services.robomaker.model.SimulationApplicationConfig;
import com.amazonaws.services.robomaker.model.VPCConfig;
import com.amazonaws.services.robomaker.model.transform.SimulationJobRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimulationJobRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private OutputLocation outputLocation;
    private LoggingConfig loggingConfig;
    private Long maxJobDurationInSeconds;
    private String iamRole;
    private String failureBehavior;
    private Boolean useDefaultApplications;
    private List<RobotApplicationConfig> robotApplications;
    private List<SimulationApplicationConfig> simulationApplications;
    private List<DataSourceConfig> dataSources;
    private VPCConfig vpcConfig;
    private Compute compute;
    private Map<String, String> tags;

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public SimulationJobRequest withOutputLocation(OutputLocation outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public SimulationJobRequest withLoggingConfig(LoggingConfig loggingConfig) {
        this.setLoggingConfig(loggingConfig);
        return this;
    }

    public void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.maxJobDurationInSeconds = maxJobDurationInSeconds;
    }

    public Long getMaxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public SimulationJobRequest withMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.setMaxJobDurationInSeconds(maxJobDurationInSeconds);
        return this;
    }

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    public SimulationJobRequest withIamRole(String iamRole) {
        this.setIamRole(iamRole);
        return this;
    }

    public void setFailureBehavior(String failureBehavior) {
        this.failureBehavior = failureBehavior;
    }

    public String getFailureBehavior() {
        return this.failureBehavior;
    }

    public SimulationJobRequest withFailureBehavior(String failureBehavior) {
        this.setFailureBehavior(failureBehavior);
        return this;
    }

    public SimulationJobRequest withFailureBehavior(FailureBehavior failureBehavior) {
        this.failureBehavior = failureBehavior.toString();
        return this;
    }

    public void setUseDefaultApplications(Boolean useDefaultApplications) {
        this.useDefaultApplications = useDefaultApplications;
    }

    public Boolean getUseDefaultApplications() {
        return this.useDefaultApplications;
    }

    public SimulationJobRequest withUseDefaultApplications(Boolean useDefaultApplications) {
        this.setUseDefaultApplications(useDefaultApplications);
        return this;
    }

    public Boolean isUseDefaultApplications() {
        return this.useDefaultApplications;
    }

    public List<RobotApplicationConfig> getRobotApplications() {
        return this.robotApplications;
    }

    public void setRobotApplications(Collection<RobotApplicationConfig> robotApplications) {
        if (robotApplications == null) {
            this.robotApplications = null;
            return;
        }
        this.robotApplications = new ArrayList<RobotApplicationConfig>(robotApplications);
    }

    public SimulationJobRequest withRobotApplications(RobotApplicationConfig ... robotApplications) {
        if (this.robotApplications == null) {
            this.setRobotApplications(new ArrayList<RobotApplicationConfig>(robotApplications.length));
        }
        for (RobotApplicationConfig ele : robotApplications) {
            this.robotApplications.add(ele);
        }
        return this;
    }

    public SimulationJobRequest withRobotApplications(Collection<RobotApplicationConfig> robotApplications) {
        this.setRobotApplications(robotApplications);
        return this;
    }

    public List<SimulationApplicationConfig> getSimulationApplications() {
        return this.simulationApplications;
    }

    public void setSimulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
        if (simulationApplications == null) {
            this.simulationApplications = null;
            return;
        }
        this.simulationApplications = new ArrayList<SimulationApplicationConfig>(simulationApplications);
    }

    public SimulationJobRequest withSimulationApplications(SimulationApplicationConfig ... simulationApplications) {
        if (this.simulationApplications == null) {
            this.setSimulationApplications(new ArrayList<SimulationApplicationConfig>(simulationApplications.length));
        }
        for (SimulationApplicationConfig ele : simulationApplications) {
            this.simulationApplications.add(ele);
        }
        return this;
    }

    public SimulationJobRequest withSimulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
        this.setSimulationApplications(simulationApplications);
        return this;
    }

    public List<DataSourceConfig> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSourceConfig> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<DataSourceConfig>(dataSources);
    }

    public SimulationJobRequest withDataSources(DataSourceConfig ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<DataSourceConfig>(dataSources.length));
        }
        for (DataSourceConfig ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public SimulationJobRequest withDataSources(Collection<DataSourceConfig> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public void setVpcConfig(VPCConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VPCConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public SimulationJobRequest withVpcConfig(VPCConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setCompute(Compute compute) {
        this.compute = compute;
    }

    public Compute getCompute() {
        return this.compute;
    }

    public SimulationJobRequest withCompute(Compute compute) {
        this.setCompute(compute);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SimulationJobRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SimulationJobRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SimulationJobRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getLoggingConfig() != null) {
            sb.append("LoggingConfig: ").append(this.getLoggingConfig()).append(",");
        }
        if (this.getMaxJobDurationInSeconds() != null) {
            sb.append("MaxJobDurationInSeconds: ").append(this.getMaxJobDurationInSeconds()).append(",");
        }
        if (this.getIamRole() != null) {
            sb.append("IamRole: ").append(this.getIamRole()).append(",");
        }
        if (this.getFailureBehavior() != null) {
            sb.append("FailureBehavior: ").append(this.getFailureBehavior()).append(",");
        }
        if (this.getUseDefaultApplications() != null) {
            sb.append("UseDefaultApplications: ").append(this.getUseDefaultApplications()).append(",");
        }
        if (this.getRobotApplications() != null) {
            sb.append("RobotApplications: ").append(this.getRobotApplications()).append(",");
        }
        if (this.getSimulationApplications() != null) {
            sb.append("SimulationApplications: ").append(this.getSimulationApplications()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getCompute() != null) {
            sb.append("Compute: ").append(this.getCompute()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobRequest)) {
            return false;
        }
        SimulationJobRequest other = (SimulationJobRequest)obj;
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getLoggingConfig() == null ^ this.getLoggingConfig() == null) {
            return false;
        }
        if (other.getLoggingConfig() != null && !other.getLoggingConfig().equals(this.getLoggingConfig())) {
            return false;
        }
        if (other.getMaxJobDurationInSeconds() == null ^ this.getMaxJobDurationInSeconds() == null) {
            return false;
        }
        if (other.getMaxJobDurationInSeconds() != null && !other.getMaxJobDurationInSeconds().equals(this.getMaxJobDurationInSeconds())) {
            return false;
        }
        if (other.getIamRole() == null ^ this.getIamRole() == null) {
            return false;
        }
        if (other.getIamRole() != null && !other.getIamRole().equals(this.getIamRole())) {
            return false;
        }
        if (other.getFailureBehavior() == null ^ this.getFailureBehavior() == null) {
            return false;
        }
        if (other.getFailureBehavior() != null && !other.getFailureBehavior().equals(this.getFailureBehavior())) {
            return false;
        }
        if (other.getUseDefaultApplications() == null ^ this.getUseDefaultApplications() == null) {
            return false;
        }
        if (other.getUseDefaultApplications() != null && !other.getUseDefaultApplications().equals(this.getUseDefaultApplications())) {
            return false;
        }
        if (other.getRobotApplications() == null ^ this.getRobotApplications() == null) {
            return false;
        }
        if (other.getRobotApplications() != null && !other.getRobotApplications().equals(this.getRobotApplications())) {
            return false;
        }
        if (other.getSimulationApplications() == null ^ this.getSimulationApplications() == null) {
            return false;
        }
        if (other.getSimulationApplications() != null && !other.getSimulationApplications().equals(this.getSimulationApplications())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getCompute() == null ^ this.getCompute() == null) {
            return false;
        }
        if (other.getCompute() != null && !other.getCompute().equals(this.getCompute())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingConfig() == null ? 0 : this.getLoggingConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMaxJobDurationInSeconds() == null ? 0 : this.getMaxJobDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getIamRole() == null ? 0 : this.getIamRole().hashCode());
        hashCode = 31 * hashCode + (this.getFailureBehavior() == null ? 0 : this.getFailureBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getUseDefaultApplications() == null ? 0 : this.getUseDefaultApplications().hashCode());
        hashCode = 31 * hashCode + (this.getRobotApplications() == null ? 0 : this.getRobotApplications().hashCode());
        hashCode = 31 * hashCode + (this.getSimulationApplications() == null ? 0 : this.getSimulationApplications().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCompute() == null ? 0 : this.getCompute().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public SimulationJobRequest clone() {
        try {
            return (SimulationJobRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SimulationJobRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

