/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal;

import com.amazonaws.Request;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.arn.Arn;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.internal.S3OutpostResource;
import com.amazonaws.services.s3.internal.UseArnRegionResolver;
import com.amazonaws.services.s3control.S3ControlClientOptions;
import com.amazonaws.services.s3control.internal.HandlerUtils;
import com.amazonaws.services.s3control.internal.S3ControlArnConverter;
import java.net.URI;

@SdkInternalApi
public class ArnHandler {
    private static final String X_AMZ_OUTPOST_ID_HEADER = "x-amz-outpost-id";
    private static final ArnHandler INSTANCE = new ArnHandler();
    private static final UseArnRegionResolver USE_ARN_REGION_RESOLVER = new UseArnRegionResolver();

    private ArnHandler() {
    }

    public static ArnHandler getInstance() {
        return INSTANCE;
    }

    public void resolveHostForArn(Request<?> request, Arn arn) {
        S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
        URI endpoint = request.getEndpoint();
        String clientRegion = (String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
        String originalArnRegion = s3Resource.getRegion();
        boolean isFipsEnabled = HandlerUtils.isFipsEnabledInClientConfig(request) || HandlerUtils.isFipsRegionProvided(clientRegion, originalArnRegion, this.useArnRegion(request));
        String arnRegion = this.removeFipsIfNeeded(originalArnRegion);
        this.validateConfiguration(request, s3Resource.getPartition(), arnRegion);
        request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)arnRegion);
        S3Resource parentS3Resource = s3Resource.getParentS3Resource();
        if (!(parentS3Resource instanceof S3OutpostResource)) {
            throw new IllegalArgumentException("Parent resource invalid, outpost resource expected.");
        }
        this.handleOutpostArn(request, (S3OutpostResource)parentS3Resource, endpoint, isFipsEnabled);
    }

    private void handleOutpostArn(Request<?> request, S3OutpostResource outpostResource, URI endpoint, boolean isFipsEnabled) {
        if (isFipsEnabled) {
            throw new IllegalArgumentException("FIPS endpints are not supported for outpost ARNs");
        }
        if (HandlerUtils.isDualstackEnabled(request)) {
            throw new IllegalArgumentException("Dualstack endpoints are not supported for outpost ARNs");
        }
        request.addHandlerContext(HandlerContextKey.SIGNING_NAME, (Object)"s3-outposts");
        request.addHeader(X_AMZ_OUTPOST_ID_HEADER, outpostResource.getOutpostId());
        String arnRegion = outpostResource.getRegion();
        URI arnEndpoint = URI.create(String.format("%s://s3-outposts.%s.%s", endpoint.getScheme(), arnRegion, RegionUtils.getRegion((String)arnRegion).getDomain()));
        request.setEndpoint(arnEndpoint);
    }

    private void validateConfiguration(Request<?> request, String arnPartition, String arnRegion) {
        String clientRegionString = this.removeFipsIfNeeded((String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION));
        Region clientRegion = RegionUtils.getRegion((String)clientRegionString);
        if (Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN))) {
            throw new IllegalArgumentException("An ARN cannot be passed to an  operation if the client has been configured with an endpoint override.");
        }
        if (!arnPartition.equals(clientRegion.getPartition())) {
            throw new IllegalArgumentException("The partition field of the ARN being passed as a bucket parameter to an S3 operation does not match the partition the client has been configured with. Provided partition: '" + arnPartition + "'; client partition: '" + clientRegion.getPartition() + "'.");
        }
        if (!arnRegion.equals(clientRegion.getName()) && !this.useArnRegion(request)) {
            throw new IllegalArgumentException("The region field of the ARN being passed as a bucket parameter to an operation does not match the region the client was configured with. Provided region: '" + arnRegion + "'; client region: '" + clientRegion.getName() + "'.");
        }
    }

    private String removeFipsIfNeeded(String region) {
        if (region.startsWith("fips-")) {
            return region.replace("fips-", "");
        }
        if (region.endsWith("-fips")) {
            return region.replace("-fips", "");
        }
        return region;
    }

    private boolean useArnRegion(Request<?> request) {
        if (HandlerUtils.isAdvancedConfigFlagTrue(request, S3ControlClientOptions.USE_ARN_REGION_ENABLED)) {
            return true;
        }
        return USE_ARN_REGION_RESOLVER.useArnRegion();
    }
}

