/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal.handlers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3control.S3ArnableField;
import com.amazonaws.services.s3control.S3ControlHandlerContextKey;
import com.amazonaws.services.s3control.internal.ArnHandler;
import com.amazonaws.services.s3control.internal.HandlerUtils;
import com.amazonaws.services.s3control.model.CreateBucketRequest;
import com.amazonaws.services.s3control.model.ListRegionalBucketsRequest;
import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

@SdkInternalApi
public final class EndpointHandler
extends RequestHandler2 {
    private final ArnHandler arnHandler;

    public EndpointHandler() {
        this.arnHandler = ArnHandler.getInstance();
    }

    @SdkTestInternalApi
    public EndpointHandler(ArnHandler arnHandler) {
        this.arnHandler = arnHandler;
    }

    public void beforeRequest(Request<?> request) {
        S3ArnableField arnableField = (S3ArnableField)request.getHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD);
        if (arnableField != null && arnableField.getArn() != null) {
            this.arnHandler.resolveHostForArn(request, arnableField.getArn());
            return;
        }
        if (this.isNonArnOutpostRequest(request)) {
            this.resolveHostForNonArnOutpostRequest(request);
            return;
        }
        this.resolveHost(request);
    }

    private void resolveHostForNonArnOutpostRequest(Request<?> request) {
        if (HandlerUtils.isDualstackEnabled(request)) {
            throw new IllegalArgumentException("Dualstack endpoints are not supported");
        }
        if (HandlerUtils.isFipsEnabledInClientConfig(request) || HandlerUtils.isFipsRegion((String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION))) {
            throw new IllegalArgumentException("FIPS endpoints are not supported");
        }
        if (Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN))) {
            throw new IllegalArgumentException("OutpostId cannot be passed to this operation if the client has been configured with an endpoint override");
        }
        request.addHandlerContext(HandlerContextKey.SIGNING_NAME, (Object)"s3-outposts");
        URI endpoint = request.getEndpoint();
        String host = endpoint.getHost();
        String newHost = host.replace("s3-control", "s3-outposts");
        int index = newHost.indexOf("s3-outposts");
        newHost = newHost.substring(index);
        try {
            request.setEndpoint(new URI(endpoint.getScheme(), endpoint.getUserInfo(), newHost, endpoint.getPort(), endpoint.getPath(), endpoint.getQuery(), endpoint.getFragment()));
        }
        catch (Exception e) {
            throw new SdkClientException("Endpoint was invalid", (Throwable)e);
        }
    }

    private boolean isNonArnOutpostRequest(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest instanceof CreateBucketRequest && !StringUtils.isNullOrEmpty((String)((CreateBucketRequest)originalRequest).getOutpostId())) {
            return true;
        }
        return originalRequest instanceof ListRegionalBucketsRequest && !StringUtils.isNullOrEmpty((String)((ListRegionalBucketsRequest)originalRequest).getOutpostId());
    }

    private void resolveHost(Request<?> request) {
        URI endpoint = request.getEndpoint();
        String host = this.doResolveHost(request);
        try {
            request.setEndpoint(new URI(endpoint.getScheme(), endpoint.getUserInfo(), host, endpoint.getPort(), endpoint.getPath(), endpoint.getQuery(), endpoint.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new SdkClientException(String.format("Endpoint was invalid: %s", host), (Throwable)e);
        }
    }

    private String doResolveHost(Request<?> request) {
        if (HandlerUtils.isDualstackEnabled(request) && HandlerUtils.isFipsEnabledInClientConfig(request)) {
            throw new SdkClientException("Cannot use both Dual-Stack endpoints and FIPS endpoints");
        }
        String host = request.getEndpoint().getHost();
        if (host == null) {
            throw new SdkClientException("Endpoint does not contain a valid host name: " + request.getEndpoint());
        }
        if (HandlerUtils.isDualstackEnabled(request)) {
            if (!host.contains("s3-control")) {
                throw new SdkClientException(String.format("The Dual-Stack option cannot be used with custom endpoints (%s)", request.getEndpoint()));
            }
            host = host.replace("s3-control", String.format("%s.%s", "s3-control", "dualstack"));
        } else if (HandlerUtils.isFipsEnabledInClientConfig(request)) {
            if (!host.contains("s3-control")) {
                throw new SdkClientException(String.format("The FIPS option cannot be used with custom endpoints (%s)", request.getEndpoint()));
            }
            host = host.replace("s3-control", String.format("%s-%s", "s3-control", "fips"));
        }
        return host;
    }
}

