/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.AccessPoint;
import com.amazonaws.services.s3control.model.transform.VpcConfigurationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AccessPointStaxUnmarshaller
implements Unmarshaller<AccessPoint, StaxUnmarshallerContext> {
    private static AccessPointStaxUnmarshaller instance;

    public AccessPoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccessPoint accessPoint = new AccessPoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return accessPoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    accessPoint.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NetworkOrigin", targetDepth)) {
                    accessPoint.setNetworkOrigin(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcConfiguration", targetDepth)) {
                    accessPoint.setVpcConfiguration(VpcConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bucket", targetDepth)) {
                    accessPoint.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccessPointArn", targetDepth)) {
                    accessPoint.setAccessPointArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Alias", targetDepth)) continue;
                accessPoint.setAlias(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return accessPoint;
    }

    public static AccessPointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AccessPointStaxUnmarshaller();
        }
        return instance;
    }
}

