/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.services.sagemaker.model.DataSource;
import com.amazonaws.services.sagemaker.model.transform.S3DataSourceJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DataSourceJsonUnmarshaller
implements Unmarshaller<DataSource, JsonUnmarshallerContext> {
    private static DataSourceJsonUnmarshaller instance;

    public DataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataSource dataSource = new DataSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3DataSource", targetDepth)) {
                    context.nextToken();
                    dataSource.setS3DataSource(S3DataSourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dataSource;
    }

    public static DataSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceJsonUnmarshaller();
        }
        return instance;
    }
}

