/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.PendingProductionVariantSummary;
import com.amazonaws.services.sagemaker.model.transform.PendingDeploymentSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PendingDeploymentSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpointConfigName;
    private List<PendingProductionVariantSummary> productionVariants;
    private Date startTime;

    public void setEndpointConfigName(String endpointConfigName) {
        this.endpointConfigName = endpointConfigName;
    }

    public String getEndpointConfigName() {
        return this.endpointConfigName;
    }

    public PendingDeploymentSummary withEndpointConfigName(String endpointConfigName) {
        this.setEndpointConfigName(endpointConfigName);
        return this;
    }

    public List<PendingProductionVariantSummary> getProductionVariants() {
        return this.productionVariants;
    }

    public void setProductionVariants(Collection<PendingProductionVariantSummary> productionVariants) {
        if (productionVariants == null) {
            this.productionVariants = null;
            return;
        }
        this.productionVariants = new ArrayList<PendingProductionVariantSummary>(productionVariants);
    }

    public PendingDeploymentSummary withProductionVariants(PendingProductionVariantSummary ... productionVariants) {
        if (this.productionVariants == null) {
            this.setProductionVariants(new ArrayList<PendingProductionVariantSummary>(productionVariants.length));
        }
        for (PendingProductionVariantSummary ele : productionVariants) {
            this.productionVariants.add(ele);
        }
        return this;
    }

    public PendingDeploymentSummary withProductionVariants(Collection<PendingProductionVariantSummary> productionVariants) {
        this.setProductionVariants(productionVariants);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public PendingDeploymentSummary withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointConfigName() != null) {
            sb.append("EndpointConfigName: ").append(this.getEndpointConfigName()).append(",");
        }
        if (this.getProductionVariants() != null) {
            sb.append("ProductionVariants: ").append(this.getProductionVariants()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingDeploymentSummary)) {
            return false;
        }
        PendingDeploymentSummary other = (PendingDeploymentSummary)obj;
        if (other.getEndpointConfigName() == null ^ this.getEndpointConfigName() == null) {
            return false;
        }
        if (other.getEndpointConfigName() != null && !other.getEndpointConfigName().equals(this.getEndpointConfigName())) {
            return false;
        }
        if (other.getProductionVariants() == null ^ this.getProductionVariants() == null) {
            return false;
        }
        if (other.getProductionVariants() != null && !other.getProductionVariants().equals(this.getProductionVariants())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        return other.getStartTime() == null || other.getStartTime().equals(this.getStartTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointConfigName() == null ? 0 : this.getEndpointConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getProductionVariants() == null ? 0 : this.getProductionVariants().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        return hashCode;
    }

    public PendingDeploymentSummary clone() {
        try {
            return (PendingDeploymentSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PendingDeploymentSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

