/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ScalingPolicy;
import com.amazonaws.services.sagemaker.model.transform.DynamicScalingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DynamicScalingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer minCapacity;
    private Integer maxCapacity;
    private Integer scaleInCooldown;
    private Integer scaleOutCooldown;
    private List<ScalingPolicy> scalingPolicies;

    public void setMinCapacity(Integer minCapacity) {
        this.minCapacity = minCapacity;
    }

    public Integer getMinCapacity() {
        return this.minCapacity;
    }

    public DynamicScalingConfiguration withMinCapacity(Integer minCapacity) {
        this.setMinCapacity(minCapacity);
        return this;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public DynamicScalingConfiguration withMaxCapacity(Integer maxCapacity) {
        this.setMaxCapacity(maxCapacity);
        return this;
    }

    public void setScaleInCooldown(Integer scaleInCooldown) {
        this.scaleInCooldown = scaleInCooldown;
    }

    public Integer getScaleInCooldown() {
        return this.scaleInCooldown;
    }

    public DynamicScalingConfiguration withScaleInCooldown(Integer scaleInCooldown) {
        this.setScaleInCooldown(scaleInCooldown);
        return this;
    }

    public void setScaleOutCooldown(Integer scaleOutCooldown) {
        this.scaleOutCooldown = scaleOutCooldown;
    }

    public Integer getScaleOutCooldown() {
        return this.scaleOutCooldown;
    }

    public DynamicScalingConfiguration withScaleOutCooldown(Integer scaleOutCooldown) {
        this.setScaleOutCooldown(scaleOutCooldown);
        return this;
    }

    public List<ScalingPolicy> getScalingPolicies() {
        return this.scalingPolicies;
    }

    public void setScalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
        if (scalingPolicies == null) {
            this.scalingPolicies = null;
            return;
        }
        this.scalingPolicies = new ArrayList<ScalingPolicy>(scalingPolicies);
    }

    public DynamicScalingConfiguration withScalingPolicies(ScalingPolicy ... scalingPolicies) {
        if (this.scalingPolicies == null) {
            this.setScalingPolicies(new ArrayList<ScalingPolicy>(scalingPolicies.length));
        }
        for (ScalingPolicy ele : scalingPolicies) {
            this.scalingPolicies.add(ele);
        }
        return this;
    }

    public DynamicScalingConfiguration withScalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
        this.setScalingPolicies(scalingPolicies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMinCapacity() != null) {
            sb.append("MinCapacity: ").append(this.getMinCapacity()).append(",");
        }
        if (this.getMaxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.getMaxCapacity()).append(",");
        }
        if (this.getScaleInCooldown() != null) {
            sb.append("ScaleInCooldown: ").append(this.getScaleInCooldown()).append(",");
        }
        if (this.getScaleOutCooldown() != null) {
            sb.append("ScaleOutCooldown: ").append(this.getScaleOutCooldown()).append(",");
        }
        if (this.getScalingPolicies() != null) {
            sb.append("ScalingPolicies: ").append(this.getScalingPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicScalingConfiguration)) {
            return false;
        }
        DynamicScalingConfiguration other = (DynamicScalingConfiguration)obj;
        if (other.getMinCapacity() == null ^ this.getMinCapacity() == null) {
            return false;
        }
        if (other.getMinCapacity() != null && !other.getMinCapacity().equals(this.getMinCapacity())) {
            return false;
        }
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null) {
            return false;
        }
        if (other.getMaxCapacity() != null && !other.getMaxCapacity().equals(this.getMaxCapacity())) {
            return false;
        }
        if (other.getScaleInCooldown() == null ^ this.getScaleInCooldown() == null) {
            return false;
        }
        if (other.getScaleInCooldown() != null && !other.getScaleInCooldown().equals(this.getScaleInCooldown())) {
            return false;
        }
        if (other.getScaleOutCooldown() == null ^ this.getScaleOutCooldown() == null) {
            return false;
        }
        if (other.getScaleOutCooldown() != null && !other.getScaleOutCooldown().equals(this.getScaleOutCooldown())) {
            return false;
        }
        if (other.getScalingPolicies() == null ^ this.getScalingPolicies() == null) {
            return false;
        }
        return other.getScalingPolicies() == null || other.getScalingPolicies().equals(this.getScalingPolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMinCapacity() == null ? 0 : this.getMinCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacity() == null ? 0 : this.getMaxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getScaleInCooldown() == null ? 0 : this.getScaleInCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getScaleOutCooldown() == null ? 0 : this.getScaleOutCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPolicies() == null ? 0 : this.getScalingPolicies().hashCode());
        return hashCode;
    }

    public DynamicScalingConfiguration clone() {
        try {
            return (DynamicScalingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamicScalingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

