/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.SpaceDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSpacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SpaceDetails> spaces;
    private String nextToken;

    public List<SpaceDetails> getSpaces() {
        return this.spaces;
    }

    public void setSpaces(Collection<SpaceDetails> spaces) {
        if (spaces == null) {
            this.spaces = null;
            return;
        }
        this.spaces = new ArrayList<SpaceDetails>(spaces);
    }

    public ListSpacesResult withSpaces(SpaceDetails ... spaces) {
        if (this.spaces == null) {
            this.setSpaces(new ArrayList<SpaceDetails>(spaces.length));
        }
        for (SpaceDetails ele : spaces) {
            this.spaces.add(ele);
        }
        return this;
    }

    public ListSpacesResult withSpaces(Collection<SpaceDetails> spaces) {
        this.setSpaces(spaces);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSpacesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSpaces() != null) {
            sb.append("Spaces: ").append(this.getSpaces()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpacesResult)) {
            return false;
        }
        ListSpacesResult other = (ListSpacesResult)obj;
        if (other.getSpaces() == null ^ this.getSpaces() == null) {
            return false;
        }
        if (other.getSpaces() != null && !other.getSpaces().equals(this.getSpaces())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSpaces() == null ? 0 : this.getSpaces().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSpacesResult clone() {
        try {
            return (ListSpacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

