/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.UserSettings;
import java.util.List;

@SdkInternalApi
public class UserSettingsMarshaller {
    private static final MarshallingInfo<String> EXECUTIONROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionRole").build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").build();
    private static final MarshallingInfo<StructuredPojo> SHARINGSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SharingSettings").build();
    private static final MarshallingInfo<StructuredPojo> JUPYTERSERVERAPPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JupyterServerAppSettings").build();
    private static final MarshallingInfo<StructuredPojo> KERNELGATEWAYAPPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KernelGatewayAppSettings").build();
    private static final MarshallingInfo<StructuredPojo> TENSORBOARDAPPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TensorBoardAppSettings").build();
    private static final MarshallingInfo<StructuredPojo> RSTUDIOSERVERPROAPPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RStudioServerProAppSettings").build();
    private static final MarshallingInfo<StructuredPojo> RSESSIONAPPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RSessionAppSettings").build();
    private static final MarshallingInfo<StructuredPojo> CANVASAPPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CanvasAppSettings").build();
    private static final MarshallingInfo<String> DEFAULTLANDINGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultLandingUri").build();
    private static final MarshallingInfo<String> STUDIOWEBPORTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StudioWebPortal").build();
    private static final UserSettingsMarshaller instance = new UserSettingsMarshaller();

    public static UserSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(UserSettings userSettings, ProtocolMarshaller protocolMarshaller) {
        if (userSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)userSettings.getExecutionRole(), EXECUTIONROLE_BINDING);
            protocolMarshaller.marshall(userSettings.getSecurityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getSharingSettings(), SHARINGSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getJupyterServerAppSettings(), JUPYTERSERVERAPPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getKernelGatewayAppSettings(), KERNELGATEWAYAPPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getTensorBoardAppSettings(), TENSORBOARDAPPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getRStudioServerProAppSettings(), RSTUDIOSERVERPROAPPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getRSessionAppSettings(), RSESSIONAPPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getCanvasAppSettings(), CANVASAPPSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getDefaultLandingUri(), DEFAULTLANDINGURI_BINDING);
            protocolMarshaller.marshall((Object)userSettings.getStudioWebPortal(), STUDIOWEBPORTAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

