/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.ClusterSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListClustersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ClusterSummary> clusterSummaries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListClustersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ClusterSummary> getClusterSummaries() {
        return this.clusterSummaries;
    }

    public void setClusterSummaries(Collection<ClusterSummary> clusterSummaries) {
        if (clusterSummaries == null) {
            this.clusterSummaries = null;
            return;
        }
        this.clusterSummaries = new ArrayList<ClusterSummary>(clusterSummaries);
    }

    public ListClustersResult withClusterSummaries(ClusterSummary ... clusterSummaries) {
        if (this.clusterSummaries == null) {
            this.setClusterSummaries(new ArrayList<ClusterSummary>(clusterSummaries.length));
        }
        for (ClusterSummary ele : clusterSummaries) {
            this.clusterSummaries.add(ele);
        }
        return this;
    }

    public ListClustersResult withClusterSummaries(Collection<ClusterSummary> clusterSummaries) {
        this.setClusterSummaries(clusterSummaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getClusterSummaries() != null) {
            sb.append("ClusterSummaries: ").append(this.getClusterSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResult)) {
            return false;
        }
        ListClustersResult other = (ListClustersResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getClusterSummaries() == null ^ this.getClusterSummaries() == null) {
            return false;
        }
        return other.getClusterSummaries() == null || other.getClusterSummaries().equals(this.getClusterSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSummaries() == null ? 0 : this.getClusterSummaries().hashCode());
        return hashCode;
    }

    public ListClustersResult clone() {
        try {
            return (ListClustersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

