/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CodeRepository;
import com.amazonaws.services.sagemaker.model.ResourceSpec;
import com.amazonaws.services.sagemaker.model.transform.SpaceJupyterLabAppSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpaceJupyterLabAppSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private ResourceSpec defaultResourceSpec;
    private List<CodeRepository> codeRepositories;

    public void setDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.defaultResourceSpec = defaultResourceSpec;
    }

    public ResourceSpec getDefaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public SpaceJupyterLabAppSettings withDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.setDefaultResourceSpec(defaultResourceSpec);
        return this;
    }

    public List<CodeRepository> getCodeRepositories() {
        return this.codeRepositories;
    }

    public void setCodeRepositories(Collection<CodeRepository> codeRepositories) {
        if (codeRepositories == null) {
            this.codeRepositories = null;
            return;
        }
        this.codeRepositories = new ArrayList<CodeRepository>(codeRepositories);
    }

    public SpaceJupyterLabAppSettings withCodeRepositories(CodeRepository ... codeRepositories) {
        if (this.codeRepositories == null) {
            this.setCodeRepositories(new ArrayList<CodeRepository>(codeRepositories.length));
        }
        for (CodeRepository ele : codeRepositories) {
            this.codeRepositories.add(ele);
        }
        return this;
    }

    public SpaceJupyterLabAppSettings withCodeRepositories(Collection<CodeRepository> codeRepositories) {
        this.setCodeRepositories(codeRepositories);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultResourceSpec() != null) {
            sb.append("DefaultResourceSpec: ").append(this.getDefaultResourceSpec()).append(",");
        }
        if (this.getCodeRepositories() != null) {
            sb.append("CodeRepositories: ").append(this.getCodeRepositories());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceJupyterLabAppSettings)) {
            return false;
        }
        SpaceJupyterLabAppSettings other = (SpaceJupyterLabAppSettings)obj;
        if (other.getDefaultResourceSpec() == null ^ this.getDefaultResourceSpec() == null) {
            return false;
        }
        if (other.getDefaultResourceSpec() != null && !other.getDefaultResourceSpec().equals(this.getDefaultResourceSpec())) {
            return false;
        }
        if (other.getCodeRepositories() == null ^ this.getCodeRepositories() == null) {
            return false;
        }
        return other.getCodeRepositories() == null || other.getCodeRepositories().equals(this.getCodeRepositories());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultResourceSpec() == null ? 0 : this.getDefaultResourceSpec().hashCode());
        hashCode = 31 * hashCode + (this.getCodeRepositories() == null ? 0 : this.getCodeRepositories().hashCode());
        return hashCode;
    }

    public SpaceJupyterLabAppSettings clone() {
        try {
            return (SpaceJupyterLabAppSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpaceJupyterLabAppSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

