/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.DomainSettings;
import java.util.List;

@SdkInternalApi
public class DomainSettingsMarshaller {
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final MarshallingInfo<StructuredPojo> RSTUDIOSERVERPRODOMAINSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RStudioServerProDomainSettings").build();
    private static final MarshallingInfo<String> EXECUTIONROLEIDENTITYCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionRoleIdentityConfig").build();
    private static final MarshallingInfo<StructuredPojo> DOCKERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DockerSettings").build();
    private static final MarshallingInfo<StructuredPojo> AMAZONQSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmazonQSettings").build();
    private static final DomainSettingsMarshaller instance = new DomainSettingsMarshaller();

    public static DomainSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(DomainSettings domainSettings, ProtocolMarshaller protocolMarshaller) {
        if (domainSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(domainSettings.getSecurityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)domainSettings.getRStudioServerProDomainSettings(), RSTUDIOSERVERPRODOMAINSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)domainSettings.getExecutionRoleIdentityConfig(), EXECUTIONROLEIDENTITYCONFIG_BINDING);
            protocolMarshaller.marshall((Object)domainSettings.getDockerSettings(), DOCKERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)domainSettings.getAmazonQSettings(), AMAZONQSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

