/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.AssociatedHost;
import java.util.List;

@SdkInternalApi
public class AssociatedHostMarshaller {
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").build();
    private static final MarshallingInfo<String> EC2INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceId").build();
    private static final MarshallingInfo<List> IPADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddresses").build();
    private static final MarshallingInfo<String> OSVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OsVersion").build();
    private static final AssociatedHostMarshaller instance = new AssociatedHostMarshaller();

    public static AssociatedHostMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssociatedHost associatedHost, ProtocolMarshaller protocolMarshaller) {
        if (associatedHost == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)associatedHost.getHostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)associatedHost.getEc2InstanceId(), EC2INSTANCEID_BINDING);
            protocolMarshaller.marshall(associatedHost.getIpAddresses(), IPADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)associatedHost.getOsVersion(), OSVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

