/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.transform.SplitDocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SplitDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer index;
    private List<Integer> pages;

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public SplitDocument withIndex(Integer index) {
        this.setIndex(index);
        return this;
    }

    public List<Integer> getPages() {
        return this.pages;
    }

    public void setPages(Collection<Integer> pages) {
        if (pages == null) {
            this.pages = null;
            return;
        }
        this.pages = new ArrayList<Integer>(pages);
    }

    public SplitDocument withPages(Integer ... pages) {
        if (this.pages == null) {
            this.setPages(new ArrayList<Integer>(pages.length));
        }
        for (Integer ele : pages) {
            this.pages.add(ele);
        }
        return this;
    }

    public SplitDocument withPages(Collection<Integer> pages) {
        this.setPages(pages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndex() != null) {
            sb.append("Index: ").append(this.getIndex()).append(",");
        }
        if (this.getPages() != null) {
            sb.append("Pages: ").append(this.getPages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitDocument)) {
            return false;
        }
        SplitDocument other = (SplitDocument)obj;
        if (other.getIndex() == null ^ this.getIndex() == null) {
            return false;
        }
        if (other.getIndex() != null && !other.getIndex().equals(this.getIndex())) {
            return false;
        }
        if (other.getPages() == null ^ this.getPages() == null) {
            return false;
        }
        return other.getPages() == null || other.getPages().equals(this.getPages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        hashCode = 31 * hashCode + (this.getPages() == null ? 0 : this.getPages().hashCode());
        return hashCode;
    }

    public SplitDocument clone() {
        try {
            return (SplitDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SplitDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

