/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestResult;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.ErroringAction;
import org.gradle.api.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;

abstract class PageRenderer<T extends CompositeTestResults>
extends TabbedPageRenderer<T> {
    private T results;
    private final TabsRenderer<T> tabsRenderer = new TabsRenderer();
    protected final ReportType reportType;

    PageRenderer(ReportType reportType) {
        this.reportType = reportType;
    }

    protected T getResults() {
        return this.results;
    }

    protected abstract void renderBreadcrumbs(SimpleHtmlWriter var1) throws IOException;

    protected abstract void registerTabs();

    protected void addTab(String title, final Action<SimpleHtmlWriter> contentRenderer) {
        this.tabsRenderer.add(title, new ReportRenderer<T, SimpleHtmlWriter>(){

            public void render(T model, SimpleHtmlWriter writer) {
                contentRenderer.execute((Object)writer);
            }
        });
    }

    protected void renderTabs(SimpleHtmlWriter htmlWriter) throws IOException {
        this.tabsRenderer.render(this.getModel(), htmlWriter);
    }

    protected void addFailuresTab() {
        if (!((CompositeTestResults)((Object)this.results)).getFailures().isEmpty()) {
            this.addTab("Failed tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                public void doExecute(SimpleHtmlWriter writer) throws IOException {
                    PageRenderer.this.renderFailures(writer);
                }
            });
        }
    }

    protected void addDeviceAndVariantTabs() {
        if (((CompositeTestResults)((Object)this.results)).getResultsPerDevices().size() > 1) {
            this.addTab("Devices", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                public void doExecute(SimpleHtmlWriter writer) throws IOException {
                    PageRenderer.this.renderCompositeResults(writer, PageRenderer.this.results.getResultsPerDevices(), "Devices");
                }
            });
        }
        if (((CompositeTestResults)((Object)this.results)).getResultsPerVariants().size() > 1) {
            this.addTab("Variants", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                public void doExecute(SimpleHtmlWriter writer) throws IOException {
                    PageRenderer.this.renderCompositeResults(writer, PageRenderer.this.results.getResultsPerVariants(), "Variants");
                }
            });
        }
    }

    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("ul").attribute("class", "linkList");
        boolean multiDevices = ((CompositeTestResults)((Object)this.results)).getResultsPerDevices().size() > 1;
        boolean multiVariants = ((CompositeTestResults)((Object)this.results)).getResultsPerVariants().size() > 1;
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        if (multiDevices) {
            htmlWriter.startElement("th").characters((CharSequence)"Devices").endElement();
        }
        if (multiVariants) {
            if (this.reportType == ReportType.MULTI_PROJECT) {
                htmlWriter.startElement("th").characters((CharSequence)"Project").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Flavor").endElement();
            } else if (this.reportType == ReportType.MULTI_FLAVOR) {
                htmlWriter.startElement("th").characters((CharSequence)"Flavor").endElement();
            }
        }
        htmlWriter.startElement("th").characters((CharSequence)"Class").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Test").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        for (TestResult test : ((CompositeTestResults)((Object)this.results)).getFailures()) {
            htmlWriter.startElement("tr");
            if (multiDevices) {
                htmlWriter.startElement("td").characters((CharSequence)test.getDevice()).endElement();
            }
            if (multiVariants) {
                if (this.reportType == ReportType.MULTI_PROJECT) {
                    htmlWriter.startElement("td").characters((CharSequence)test.getProject()).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)test.getFlavor()).endElement();
                } else if (this.reportType == ReportType.MULTI_FLAVOR) {
                    htmlWriter.startElement("td").characters((CharSequence)test.getFlavor()).endElement();
                }
            }
            htmlWriter.startElement("td").attribute("class", test.getStatusClass());
            htmlWriter.endElement();
            htmlWriter.startElement("td").startElement("a").attribute("href", String.format("%s.html", test.getClassResults().getFilename(this.reportType))).characters((CharSequence)test.getClassResults().getSimpleName()).endElement().endElement();
            htmlWriter.startElement("td").startElement("a").attribute("href", String.format("%s.html#s", test.getClassResults().getFilename(this.reportType), test.getName())).characters((CharSequence)test.getName()).endElement().endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }

    protected void renderCompositeResults(SimpleHtmlWriter htmlWriter, Map<String, ? extends CompositeTestResults> map, String name) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters((CharSequence)name).endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        for (CompositeTestResults compositeTestResults : map.values()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", compositeTestResults.getStatusClass()).characters((CharSequence)compositeTestResults.getName()).endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(compositeTestResults.getTestCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(compositeTestResults.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)compositeTestResults.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").characters((CharSequence)compositeTestResults.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    protected String getTitle() {
        return ((CompositeTestResults)((Object)this.getModel())).getTitle();
    }

    protected String getPageTitle() {
        return String.format("Test results - %s", ((CompositeTestResults)((Object)this.getModel())).getTitle());
    }

    protected ReportRenderer<T, SimpleHtmlWriter> getHeaderRenderer() {
        return new ReportRenderer<T, SimpleHtmlWriter>(){

            public void render(T model, SimpleHtmlWriter htmlWriter) throws IOException {
                PageRenderer.this.results = model;
                PageRenderer.this.renderBreadcrumbs(htmlWriter);
                htmlWriter.startElement("div").attribute("id", "summary");
                htmlWriter.startElement("table");
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "summaryGroup");
                htmlWriter.startElement("table");
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "tests");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(PageRenderer.this.results.getTestCount())).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"tests").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "failures");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(PageRenderer.this.results.getFailureCount())).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"failures").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", "infoBox").attribute("id", "duration");
                htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)PageRenderer.this.results.getFormattedDuration()).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"duration").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.startElement("td");
                htmlWriter.startElement("div").attribute("class", String.format("infoBox %s", PageRenderer.this.results.getStatusClass())).attribute("id", "successRate");
                htmlWriter.startElement("div").attribute("class", "percent").characters((CharSequence)PageRenderer.this.results.getFormattedSuccessRate()).endElement();
                htmlWriter.startElement("p").characters((CharSequence)"successful").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
            }
        };
    }

    protected ReportRenderer<T, SimpleHtmlWriter> getContentRenderer() {
        return new ReportRenderer<T, SimpleHtmlWriter>(){

            public void render(T model, SimpleHtmlWriter htmlWriter) throws IOException {
                PageRenderer.this.results = model;
                PageRenderer.this.tabsRenderer.clear();
                PageRenderer.this.registerTabs();
                PageRenderer.this.renderTabs(htmlWriter);
            }
        };
    }
}

