/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.VariantConfiguration;
import com.google.common.collect.Lists;
import java.util.List;

public class TestVariantData
extends ApkVariantData {
    public DeviceProviderInstrumentTestTask connectedTestTask;
    public final List<DeviceProviderInstrumentTestTask> providerTestTaskList = Lists.newArrayList();
    @NonNull
    private final TestedVariantData testedVariantData;

    public TestVariantData(@NonNull VariantConfiguration config, @NonNull TestedVariantData testedVariantData) {
        super(config);
        this.testedVariantData = testedVariantData;
    }

    @NonNull
    public TestedVariantData getTestedVariantData() {
        return this.testedVariantData;
    }

    @Override
    @NonNull
    protected String computeName() {
        return this.getVariantConfiguration().hasFlavors() ? String.format("%sTest", this.getFlavoredName(true)) : "Test";
    }

    @Override
    @NonNull
    public String getDescription() {
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("Test build for the %s%s build", this.getFlavoredName(true), this.getCapitalizedBuildTypeName());
        }
        return String.format("Test build for the %s build", this.getCapitalizedBuildTypeName());
    }

    @Override
    @NonNull
    public String getDirName() {
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("%s/test", this.getFlavoredName(false));
        }
        return "test";
    }

    @Override
    @NonNull
    public String getBaseName() {
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("%s-test", this.getFlavoredName(false));
        }
        return "test";
    }

    @Override
    public boolean getZipAlign() {
        return false;
    }

    @Override
    public boolean getRunProguard() {
        return false;
    }
}

