/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.annotations.NonNull;
import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.ILogger;

public class LoggedProcessOutputHandler
extends BaseProcessOutputHandler {
    @NonNull
    private final ILogger mLogger;

    public LoggedProcessOutputHandler(@NonNull ILogger logger) {
        this.mLogger = logger;
    }

    @Override
    public void handleOutput(@NonNull ProcessOutput processOutput) throws ProcessException {
        if (processOutput instanceof BaseProcessOutputHandler.BaseProcessOutput) {
            String stderr;
            BaseProcessOutputHandler.BaseProcessOutput impl = (BaseProcessOutputHandler.BaseProcessOutput)processOutput;
            String stdout = impl.getStandardOutputAsString();
            if (!stdout.isEmpty()) {
                this.mLogger.info(stdout, new Object[0]);
            }
            if (!(stderr = impl.getErrorOutputAsString()).isEmpty()) {
                this.mLogger.error(null, stderr, new Object[0]);
            }
        } else {
            throw new IllegalArgumentException("processOutput was not created by this handler.");
        }
    }
}

