/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.ParsingUtils;
import com.ibm.icu.impl.number.parse.UnicodeSetStaticCache;
import com.ibm.icu.text.UnicodeSet;

public abstract class SymbolMatcher
implements NumberParseMatcher {
    protected final String string;
    protected final UnicodeSet uniSet;

    protected SymbolMatcher(String symbolString, UnicodeSet symbolUniSet) {
        this.string = symbolString;
        this.uniSet = symbolUniSet;
    }

    protected SymbolMatcher(UnicodeSetStaticCache.Key key) {
        this.string = "";
        this.uniSet = UnicodeSetStaticCache.get(key);
    }

    public UnicodeSet getSet() {
        return this.uniSet;
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result) {
        if (this.isDisabled(result)) {
            return false;
        }
        int overlap = 0;
        if (!this.string.isEmpty() && (overlap = segment.getCommonPrefixLength(this.string)) == this.string.length()) {
            segment.adjustOffset(this.string.length());
            this.accept(segment, result);
            return false;
        }
        if (segment.startsWith(this.uniSet)) {
            segment.adjustOffsetByCodePoint();
            this.accept(segment, result);
            return false;
        }
        return overlap == segment.length();
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        if (this.string.isEmpty()) {
            return this.uniSet;
        }
        UnicodeSet leadCodePoints = new UnicodeSet();
        ParsingUtils.putLeadCodePoints(this.uniSet, leadCodePoints);
        ParsingUtils.putLeadCodePoint(this.string, leadCodePoints);
        return leadCodePoints.freeze();
    }

    @Override
    public void postProcess(ParsedNumber result) {
    }

    protected abstract boolean isDisabled(ParsedNumber var1);

    protected abstract void accept(StringSegment var1, ParsedNumber var2);
}

