/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.FetchedValue;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.nextgen.ExecutionHelper;
import graphql.execution.nextgen.ExecutionStrategy;
import graphql.execution.nextgen.ExecutionStrategyUtil;
import graphql.execution.nextgen.FetchedValueAnalysis;
import graphql.execution.nextgen.FetchedValueAnalyzer;
import graphql.execution.nextgen.FieldSubSelection;
import graphql.execution.nextgen.ValueFetcher;
import graphql.execution.nextgen.result.ExecutionResultNode;
import graphql.execution.nextgen.result.ResultNodeAdapter;
import graphql.execution.nextgen.result.ResultNodesUtil;
import graphql.execution.nextgen.result.RootExecutionResultNode;
import graphql.execution.nextgen.result.UnresolvedObjectResultNode;
import graphql.util.FpKit;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Internal
public class BatchedExecutionStrategy
implements ExecutionStrategy {
    ExecutionStepInfoFactory executionInfoFactory = new ExecutionStepInfoFactory();
    ValueFetcher valueFetcher = new ValueFetcher();
    FetchedValueAnalyzer fetchedValueAnalyzer = new FetchedValueAnalyzer();
    ExecutionStrategyUtil util = new ExecutionStrategyUtil();
    ExecutionHelper executionHelper = new ExecutionHelper();

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext context) {
        FieldSubSelection fieldSubSelection = this.executionHelper.getFieldSubSelection(context);
        return this.executeImpl(context, fieldSubSelection).thenApply(ResultNodesUtil::toExecutionResult);
    }

    public CompletableFuture<RootExecutionResultNode> executeImpl(ExecutionContext executionContext, FieldSubSelection fieldSubSelection) {
        CompletionStage rootCF = Async.each(this.util.fetchSubSelection(executionContext, fieldSubSelection)).thenApply(RootExecutionResultNode::new);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)rootCF).thenCompose(rootNode -> {
            NodeMultiZipper<ExecutionResultNode> unresolvedNodes = ResultNodesUtil.getUnresolvedNodes(rootNode);
            return this.nextStep(executionContext, unresolvedNodes);
        })).thenApply(multiZipper -> (ExecutionResultNode)multiZipper.toRootNode())).thenApply(RootExecutionResultNode.class::cast);
    }

    private CompletableFuture<NodeMultiZipper<ExecutionResultNode>> nextStep(ExecutionContext executionContext, NodeMultiZipper<ExecutionResultNode> multizipper) {
        NodeMultiZipper<ExecutionResultNode> nextUnresolvedNodes = ResultNodesUtil.getUnresolvedNodes(multizipper.toRootNode());
        if (nextUnresolvedNodes.getZippers().size() == 0) {
            return CompletableFuture.completedFuture(nextUnresolvedNodes);
        }
        List<NodeMultiZipper<ExecutionResultNode>> groups = this.groupNodesIntoBatches(nextUnresolvedNodes);
        return this.resolveNodes(executionContext, groups).thenCompose(next -> this.nextStep(executionContext, (NodeMultiZipper<ExecutionResultNode>)next));
    }

    private CompletableFuture<NodeMultiZipper<ExecutionResultNode>> resolveNodes(ExecutionContext executionContext, List<NodeMultiZipper<ExecutionResultNode>> unresolvedNodes) {
        Assert.assertNotEmpty(unresolvedNodes, () -> "unresolvedNodes can't be empty");
        ExecutionResultNode commonRoot = unresolvedNodes.get(0).getCommonRoot();
        CompletableFuture listListCF = Async.flatMap(unresolvedNodes, executionResultMultiZipper -> this.fetchAndAnalyze(executionContext, executionResultMultiZipper.getZippers()));
        return FpKit.flatList(listListCF).thenApply(zippers -> new NodeMultiZipper<ExecutionResultNode>(commonRoot, (List<NodeZipper<ExecutionResultNode>>)zippers, ResultNodeAdapter.RESULT_NODE_ADAPTER));
    }

    private List<NodeMultiZipper<ExecutionResultNode>> groupNodesIntoBatches(NodeMultiZipper<ExecutionResultNode> unresolvedZipper) {
        Map<MergedField, ImmutableList<NodeZipper>> zipperBySubSelection = FpKit.groupingBy(unresolvedZipper.getZippers(), executionResultZipper -> ((ExecutionResultNode)executionResultZipper.getCurNode()).getMergedField());
        return FpKit.mapEntries(zipperBySubSelection, (key, value) -> new NodeMultiZipper<ExecutionResultNode>((ExecutionResultNode)unresolvedZipper.getCommonRoot(), (List<NodeZipper<ExecutionResultNode>>)value, ResultNodeAdapter.RESULT_NODE_ADAPTER));
    }

    private CompletableFuture<List<NodeZipper<ExecutionResultNode>>> fetchAndAnalyze(ExecutionContext executionContext, List<NodeZipper<ExecutionResultNode>> unresolvedNodes) {
        Assert.assertTrue(unresolvedNodes.size() > 0, () -> "unresolvedNodes can't be empty");
        ImmutableList<FieldSubSelection> fieldSubSelections = ImmutableKit.map(unresolvedNodes, node -> this.util.createFieldSubSelection(executionContext, ((ExecutionResultNode)node.getCurNode()).getExecutionStepInfo(), ((ExecutionResultNode)node.getCurNode()).getResolvedValue()));
        MergedSelectionSet mergedSelectionSet = ((FieldSubSelection)fieldSubSelections.get(0)).getMergedSelectionSet();
        List<CompletableFuture<List<FetchedValueAnalysis>>> fetchedValues = this.batchFetchForEachSubField(executionContext, fieldSubSelections, mergedSelectionSet);
        return this.mapBatchedResultsBack(unresolvedNodes, fetchedValues);
    }

    private CompletableFuture<List<NodeZipper<ExecutionResultNode>>> mapBatchedResultsBack(List<NodeZipper<ExecutionResultNode>> unresolvedNodes, List<CompletableFuture<List<FetchedValueAnalysis>>> fetchedValues) {
        return Async.each(fetchedValues).thenApply(fetchedValuesMatrix -> {
            ArrayList<NodeZipper<ExecutionResultNode>> result = new ArrayList<NodeZipper<ExecutionResultNode>>();
            List newChildsPerNode = FpKit.transposeMatrix(fetchedValuesMatrix);
            for (int i = 0; i < newChildsPerNode.size(); ++i) {
                NodeZipper unresolvedNodeZipper = (NodeZipper)unresolvedNodes.get(i);
                List<FetchedValueAnalysis> fetchedValuesForNode = newChildsPerNode.get(i);
                NodeZipper<ExecutionResultNode> resolvedZipper = this.resolveZipper(unresolvedNodeZipper, fetchedValuesForNode);
                result.add(resolvedZipper);
            }
            return result;
        });
    }

    private List<CompletableFuture<List<FetchedValueAnalysis>>> batchFetchForEachSubField(ExecutionContext executionContext, List<FieldSubSelection> fieldSubSelections, MergedSelectionSet mergedSelectionSet) {
        ImmutableList<Object> sources = ImmutableKit.map(fieldSubSelections, FieldSubSelection::getSource);
        return FpKit.mapEntries(mergedSelectionSet.getSubFields(), (name, mergedField) -> {
            List<ExecutionStepInfo> newExecutionStepInfos = this.newExecutionInfos(executionContext, fieldSubSelections, (MergedField)mergedField);
            return this.valueFetcher.fetchBatchedValues(executionContext, (List<Object>)sources, (MergedField)mergedField, newExecutionStepInfos).thenApply(fetchValue -> this.analyseValues(executionContext, (List<FetchedValue>)fetchValue, newExecutionStepInfos));
        });
    }

    private List<ExecutionStepInfo> newExecutionInfos(ExecutionContext executionContext, List<FieldSubSelection> fieldSubSelections, MergedField mergedField) {
        return ImmutableKit.map(fieldSubSelections, subSelection -> this.executionInfoFactory.newExecutionStepInfoForSubField(executionContext, mergedField, subSelection.getExecutionStepInfo()));
    }

    private NodeZipper<ExecutionResultNode> resolveZipper(NodeZipper<ExecutionResultNode> unresolvedNodeZipper, List<FetchedValueAnalysis> fetchedValuesForNode) {
        UnresolvedObjectResultNode unresolvedNode = (UnresolvedObjectResultNode)unresolvedNodeZipper.getCurNode();
        List<ExecutionResultNode> newChildren = this.util.fetchedValueAnalysisToNodes(fetchedValuesForNode);
        ExecutionResultNode newNode = unresolvedNode.withNewChildren((List)newChildren);
        return unresolvedNodeZipper.withNewNode(newNode);
    }

    private List<FetchedValueAnalysis> analyseValues(ExecutionContext executionContext, List<FetchedValue> fetchedValues, List<ExecutionStepInfo> executionInfos) {
        ArrayList<FetchedValueAnalysis> result = new ArrayList<FetchedValueAnalysis>();
        for (int i = 0; i < fetchedValues.size(); ++i) {
            FetchedValue fetchedValue = fetchedValues.get(i);
            ExecutionStepInfo executionStepInfo = executionInfos.get(i);
            FetchedValueAnalysis fetchedValueAnalysis = this.fetchedValueAnalyzer.analyzeFetchedValue(executionContext, fetchedValue, executionStepInfo);
            result.add(fetchedValueAnalysis);
        }
        return result;
    }
}

