/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.IgnoredChars;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeVisitor;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class SchemaDefinition
extends AbstractDescribedNode<SchemaDefinition>
implements SDLDefinition<SchemaDefinition>,
DirectivesContainer<SchemaDefinition> {
    private final ImmutableList<Directive> directives;
    private final ImmutableList<OperationTypeDefinition> operationTypeDefinitions;
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_OPERATION_TYPE_DEFINITIONS = "operationTypeDefinitions";

    @Internal
    protected SchemaDefinition(List<Directive> directives, List<OperationTypeDefinition> operationTypeDefinitions, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData, Description description2) {
        super(sourceLocation, comments, ignoredChars, additionalData, description2);
        this.directives = ImmutableList.copyOf(directives);
        this.operationTypeDefinitions = ImmutableList.copyOf(operationTypeDefinitions);
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public List<OperationTypeDefinition> getOperationTypeDefinitions() {
        return this.operationTypeDefinitions;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.operationTypeDefinitions);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_DIRECTIVES, this.directives).children(CHILD_OPERATION_TYPE_DEFINITIONS, this.operationTypeDefinitions).build();
    }

    @Override
    public SchemaDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.directives(newChildren.getChildren(CHILD_DIRECTIVES)).operationTypeDefinitions(newChildren.getChildren(CHILD_OPERATION_TYPE_DEFINITIONS)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    @Override
    public SchemaDefinition deepCopy() {
        return new SchemaDefinition(this.deepCopy(this.directives), this.deepCopy(this.operationTypeDefinitions), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData(), this.description);
    }

    public String toString() {
        return "SchemaDefinition{directives=" + this.directives + ", operationTypeDefinitions=" + this.operationTypeDefinitions + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitSchemaDefinition(this, context);
    }

    public SchemaDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newSchemaDefinition() {
        return new Builder();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private ImmutableList<OperationTypeDefinition> operationTypeDefinitions = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();
        private Description description;

        protected Builder() {
        }

        protected Builder(SchemaDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.operationTypeDefinitions = ImmutableList.copyOf(existing.getOperationTypeDefinitions());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
            this.description = existing.getDescription();
        }

        public Builder description(Description description2) {
            this.description = description2;
            return this;
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        public Builder operationTypeDefinitions(List<OperationTypeDefinition> operationTypeDefinitions) {
            this.operationTypeDefinitions = ImmutableList.copyOf(operationTypeDefinitions);
            return this;
        }

        public Builder operationTypeDefinition(OperationTypeDefinition operationTypeDefinition) {
            this.operationTypeDefinitions = ImmutableKit.addToList(this.operationTypeDefinitions, operationTypeDefinition, new OperationTypeDefinition[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public SchemaDefinition build() {
            return new SchemaDefinition(this.directives, this.operationTypeDefinitions, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData, this.description);
        }
    }
}

