/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.IgnoredChars;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.SDLExtensionDefinition;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.UnionTypeDefinition;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class UnionTypeExtensionDefinition
extends UnionTypeDefinition
implements SDLExtensionDefinition {
    @Internal
    protected UnionTypeExtensionDefinition(String name, List<Directive> directives, List<Type> memberTypes, Description description2, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(name, directives, memberTypes, description2, sourceLocation, comments, ignoredChars, additionalData);
    }

    @Override
    public UnionTypeExtensionDefinition deepCopy() {
        return new UnionTypeExtensionDefinition(this.getName(), this.deepCopy(this.getDirectives()), this.deepCopy(this.getMemberTypes()), this.getDescription(), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    @Override
    public String toString() {
        return "UnionTypeExtensionDefinition{name='" + this.getName() + '\'' + "directives=" + this.getDirectives() + ", memberTypes=" + this.getMemberTypes() + '}';
    }

    public static Builder newUnionTypeExtensionDefinition() {
        return new Builder();
    }

    @Override
    public UnionTypeExtensionDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transformExtension(builder -> ((Builder)builder.directives(newChildren.getChildren("directives"))).memberTypes(newChildren.getChildren("memberTypes")));
    }

    public UnionTypeExtensionDefinition transformExtension(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Description description;
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private ImmutableList<Type> memberTypes = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(UnionTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.memberTypes = ImmutableList.copyOf(existing.getMemberTypes());
            this.ignoredChars = existing.getIgnoredChars();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description2) {
            this.description = description2;
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        public Builder memberTypes(List<Type> memberTypes) {
            this.memberTypes = ImmutableList.copyOf(memberTypes);
            return this;
        }

        public Builder memberType(Type memberType) {
            this.memberTypes = ImmutableKit.addToList(this.memberTypes, memberType, new Type[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public UnionTypeExtensionDefinition build() {
            return new UnionTypeExtensionDefinition(this.name, this.directives, this.memberTypes, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

