/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.introspection.Introspection;
import graphql.language.DirectiveDefinition;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLDirective
implements GraphQLNamedSchemaElement {
    private final String name;
    private final boolean repeatable;
    private final String description;
    private final EnumSet<Introspection.DirectiveLocation> locations;
    private final ImmutableList<GraphQLArgument> arguments;
    private final DirectiveDefinition definition;
    public static final String CHILD_ARGUMENTS = "arguments";

    private GraphQLDirective(String name, String description2, boolean repeatable, EnumSet<Introspection.DirectiveLocation> locations, List<GraphQLArgument> arguments2, DirectiveDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(arguments2, () -> "arguments can't be null");
        this.name = name;
        this.description = description2;
        this.repeatable = repeatable;
        this.locations = locations;
        this.arguments = ImmutableList.copyOf(arguments2);
        this.definition = definition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean isNonRepeatable() {
        return !this.repeatable;
    }

    public List<GraphQLArgument> getArguments() {
        return this.arguments;
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public EnumSet<Introspection.DirectiveLocation> validLocations() {
        return EnumSet.copyOf(this.locations);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DirectiveDefinition getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "GraphQLDirective{name='" + this.name + '\'' + ", repeatable='" + this.repeatable + '\'' + ", arguments=" + this.arguments + ", locations=" + this.locations + '}';
    }

    public GraphQLDirective transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLDirective.newDirective(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLDirective.newDirective(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLDirective(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        return ImmutableList.copyOf(this.arguments);
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_ARGUMENTS, this.arguments).build();
    }

    @Override
    public GraphQLDirective withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceArguments(newChildren.getChildren(CHILD_ARGUMENTS)));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public static Builder newDirective(GraphQLDirective existing) {
        return new Builder(existing);
    }

    public static class Builder
    extends GraphqlTypeBuilder {
        private EnumSet<Introspection.DirectiveLocation> locations = EnumSet.noneOf(Introspection.DirectiveLocation.class);
        private final Map<String, GraphQLArgument> arguments = new LinkedHashMap<String, GraphQLArgument>();
        private DirectiveDefinition definition;
        private boolean repeatable = false;

        public Builder() {
        }

        public Builder(GraphQLDirective existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.repeatable = existing.isRepeatable();
            this.locations = existing.validLocations();
            this.arguments.putAll(FpKit.getByName(existing.getArguments(), GraphQLArgument::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description2) {
            super.description(description2);
            return this;
        }

        public Builder repeatable(boolean repeatable) {
            this.repeatable = repeatable;
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder validLocations(Introspection.DirectiveLocation ... validLocations) {
            Collections.addAll(this.locations, validLocations);
            return this;
        }

        public Builder validLocation(Introspection.DirectiveLocation validLocation) {
            this.locations.add(validLocation);
            return this;
        }

        public Builder clearValidLocations() {
            this.locations = EnumSet.noneOf(Introspection.DirectiveLocation.class);
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            Assert.assertNotNull(argument, () -> "argument must not be null");
            this.arguments.put(argument.getName(), argument);
            return this;
        }

        public Builder replaceArguments(List<GraphQLArgument> arguments2) {
            Assert.assertNotNull(arguments2, () -> "arguments must not be null");
            this.arguments.clear();
            for (GraphQLArgument argument : arguments2) {
                this.arguments.put(argument.getName(), argument);
            }
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLArgument.Builder> builderFunction) {
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            builder = (GraphQLArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLArgument.Builder builder) {
            return this.argument(builder.build());
        }

        public Builder clearArguments() {
            this.arguments.clear();
            return this;
        }

        public Builder definition(DirectiveDefinition definition) {
            this.definition = definition;
            return this;
        }

        public GraphQLDirective build() {
            return new GraphQLDirective(this.name, this.description, this.repeatable, this.locations, this.sort(this.arguments, GraphQLDirective.class, GraphQLArgument.class), this.definition);
        }
    }
}

