/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.TrivialDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.PropertyDataFetcherHelper;
import java.util.function.Function;

@PublicApi
public class PropertyDataFetcher<T>
implements DataFetcher<T>,
TrivialDataFetcher<T> {
    private final String propertyName;
    private final Function<Object, Object> function;

    public PropertyDataFetcher(String propertyName) {
        this.propertyName = Assert.assertNotNull(propertyName);
        this.function = null;
    }

    private <O> PropertyDataFetcher(Function<O, T> function) {
        this.function = Assert.assertNotNull(function);
        this.propertyName = null;
    }

    public static <T> PropertyDataFetcher<T> fetching(String propertyName) {
        return new PropertyDataFetcher<T>(propertyName);
    }

    public static <T, O> PropertyDataFetcher<T> fetching(Function<O, T> function) {
        return new PropertyDataFetcher<T>(function);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public T get(DataFetchingEnvironment environment) {
        Object source2 = environment.getSource();
        if (source2 == null) {
            return null;
        }
        if (this.function != null) {
            return (T)this.function.apply(source2);
        }
        return (T)PropertyDataFetcherHelper.getPropertyValue(this.propertyName, source2, environment.getFieldType(), environment);
    }

    public static void clearReflectionCache() {
        PropertyDataFetcherHelper.clearReflectionCache();
    }

    public static boolean setUseSetAccessible(boolean flag) {
        return PropertyDataFetcherHelper.setUseSetAccessible(flag);
    }

    public static boolean setUseNegativeCache(boolean flag) {
        return PropertyDataFetcherHelper.setUseNegativeCache(flag);
    }
}

