/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.AssertException;
import graphql.Directives;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.TypeResolverProxy;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaGeneratorDirectiveHelper;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.schema.idl.errors.NotAnOutputTypeError;
import graphql.util.FpKit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class SchemaGeneratorHelper {
    static final String NO_LONGER_SUPPORTED = "No longer supported";

    private static Description createDescription(String s2) {
        return new Description(s2, null, false);
    }

    String buildDescription(BuildContext buildContext, Node<?> node, Description description2) {
        if (description2 != null) {
            return description2.getContent();
        }
        if (!buildContext.options.isUseCommentsAsDescription()) {
            return null;
        }
        List<Comment> comments = node.getComments();
        ArrayList<String> lines = new ArrayList<String>();
        for (Comment comment : comments) {
            String commentLine = comment.getContent();
            if (commentLine.trim().isEmpty()) {
                lines.clear();
                continue;
            }
            lines.add(commentLine);
        }
        if (lines.size() == 0) {
            return null;
        }
        return String.join((CharSequence)"\n", lines);
    }

    String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = Optional.ofNullable(directives).orElse(Collections.emptyList())).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return NO_LONGER_SUPPORTED;
            }
            return args.get("reason");
        }
        return null;
    }

    private GraphQLDirective buildAppliedDirective(BuildContext buildCtx, Directive directive, Introspection.DirectiveLocation directiveLocation, Set<GraphQLDirective> runtimeDirectives, GraphqlTypeComparatorRegistry comparatorRegistry, Set<String> previousNames) {
        GraphQLDirective gqlDirective = this.buildAppliedDirective(buildCtx, directive, runtimeDirectives, directiveLocation, comparatorRegistry);
        if (previousNames.contains(directive.getName())) {
            Assert.assertTrue(gqlDirective.isRepeatable(), () -> String.format("The directive '%s' MUST be defined as a repeatable directive if its repeated on an SDL element", directive.getName()));
        }
        previousNames.add(gqlDirective.getName());
        return gqlDirective;
    }

    GraphQLDirective buildAppliedDirective(BuildContext buildCtx, Directive directive, Set<GraphQLDirective> directiveDefinitions, Introspection.DirectiveLocation directiveLocation, GraphqlTypeComparatorRegistry comparatorRegistry) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(this.buildDescription(buildCtx, directive, null)).comparatorRegistry(comparatorRegistry).validLocations(directiveLocation);
        Optional<GraphQLDirective> directiveDefOpt = FpKit.findOne(directiveDefinitions, dd -> dd.getName().equals(directive.getName()));
        GraphQLDirective graphQLDirective = directiveDefOpt.orElseGet(() -> {
            Function<Type, GraphQLInputType> inputTypeFactory = inputType -> this.buildInputType(buildCtx, (Type)inputType);
            return this.buildDirectiveDefinitionFromAst(buildCtx, buildCtx.getTypeRegistry().getDirectiveDefinition(directive.getName()).get(), inputTypeFactory);
        });
        builder.repeatable(graphQLDirective.isRepeatable());
        List<GraphQLArgument> appliedArguments = ImmutableKit.map(directive.getArguments(), arg -> this.buildAppliedDArgument((Argument)arg, graphQLDirective));
        appliedArguments = this.transferMissingArguments(buildCtx, appliedArguments, graphQLDirective);
        appliedArguments.forEach(builder::argument);
        return builder.build();
    }

    private GraphQLArgument buildAppliedDArgument(Argument arg, GraphQLDirective directiveDefinition) {
        GraphQLArgument directiveDefArgument = directiveDefinition.getArgument(arg.getName());
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name(arg.getName());
        GraphQLInputType inputType = directiveDefArgument.getType();
        builder.type(inputType);
        if (directiveDefArgument.getArgumentDefaultValue().isSet()) {
            builder.defaultValueLiteral((Value)directiveDefArgument.getArgumentDefaultValue().getValue());
        }
        if (arg.getValue() != null) {
            builder.valueLiteral(arg.getValue());
        }
        return builder.build();
    }

    private List<GraphQLArgument> transferMissingArguments(BuildContext buildCtx, List<GraphQLArgument> arguments2, GraphQLDirective directiveDefinition) {
        Map<String, GraphQLArgument> declaredArgs = FpKit.getByName(arguments2, GraphQLArgument::getName, FpKit.mergeFirst());
        ArrayList<GraphQLArgument> argumentsOut = new ArrayList<GraphQLArgument>(arguments2);
        for (GraphQLArgument directiveDefArg : directiveDefinition.getArguments()) {
            if (declaredArgs.containsKey(directiveDefArg.getName())) continue;
            GraphQLArgument.Builder missingArg = GraphQLArgument.newArgument().name(directiveDefArg.getName()).description(directiveDefArg.getDescription()).definition(buildCtx.isCaptureAstDefinitions() ? directiveDefArg.getDefinition() : null).type(directiveDefArg.getType());
            if (directiveDefArg.hasSetDefaultValue()) {
                missingArg.defaultValueLiteral((Value)directiveDefArg.getArgumentDefaultValue().getValue());
            }
            if (directiveDefArg.hasSetValue()) {
                missingArg.valueLiteral((Value)directiveDefArg.getArgumentValue().getValue());
            }
            argumentsOut.add(missingArg.build());
        }
        return argumentsOut;
    }

    GraphQLDirective buildDirectiveDefinitionFromAst(BuildContext buildCtx, DirectiveDefinition directiveDefinition, Function<Type, GraphQLInputType> inputTypeFactory) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directiveDefinition.getName()).definition(buildCtx.isCaptureAstDefinitions() ? directiveDefinition : null).repeatable(directiveDefinition.isRepeatable()).description(this.buildDescription(buildCtx, directiveDefinition, directiveDefinition.getDescription()));
        List<Introspection.DirectiveLocation> locations = this.buildLocations(directiveDefinition);
        locations.forEach(xva$0 -> builder.validLocations((Introspection.DirectiveLocation)((Object)xva$0)));
        ImmutableList<GraphQLArgument> arguments2 = ImmutableKit.map(directiveDefinition.getInputValueDefinitions(), arg -> this.buildDirectiveArgumentDefinitionFromAst(buildCtx, (InputValueDefinition)arg, inputTypeFactory));
        arguments2.forEach(builder::argument);
        return builder.build();
    }

    private List<Introspection.DirectiveLocation> buildLocations(DirectiveDefinition directiveDefinition) {
        return ImmutableKit.map(directiveDefinition.getDirectiveLocations(), dl -> Introspection.DirectiveLocation.valueOf(dl.getName().toUpperCase()));
    }

    private GraphQLArgument buildDirectiveArgumentDefinitionFromAst(BuildContext buildCtx, InputValueDefinition arg, Function<Type, GraphQLInputType> inputTypeFactory) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(arg.getName()).definition(buildCtx.isCaptureAstDefinitions() ? arg : null);
        GraphQLInputType inputType = inputTypeFactory.apply(arg.getType());
        builder.type(inputType);
        if (arg.getDefaultValue() != null) {
            builder.valueLiteral(arg.getDefaultValue());
            builder.defaultValueLiteral(arg.getDefaultValue());
        }
        builder.description(this.buildDescription(buildCtx, arg, arg.getDescription()));
        return builder.build();
    }

    GraphQLInputType buildInputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLInputType inputType = buildCtx.hasInputType(typeDefinition);
        if (inputType != null) {
            return (GraphQLInputType)typeInfo.decorate(inputType);
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (GraphQLInputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName()));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof InputObjectTypeDefinition) {
            inputType = this.buildInputObjectType(buildCtx, (InputObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            inputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            inputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnInputTypeError(rawType, typeDefinition);
        }
        buildCtx.putInputType((GraphQLNamedInputType)inputType);
        buildCtx.pop();
        return (GraphQLInputType)typeInfo.decorate(inputType);
    }

    GraphQLInputObjectType buildInputObjectType(BuildContext buildCtx, InputObjectTypeDefinition typeDefinition) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InputObjectTypeExtensionDefinition> extensions = this.inputObjectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        builder.withDirectives(this.buildAppliedDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.INPUT_OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        typeDefinition.getInputValueDefinitions().forEach(inputValue -> builder.field(this.buildInputField(buildCtx, (InputValueDefinition)inputValue)));
        extensions.forEach(extension -> extension.getInputValueDefinitions().forEach(inputValueDefinition -> {
            GraphQLInputObjectField inputField = this.buildInputField(buildCtx, (InputValueDefinition)inputValueDefinition);
            if (!builder.hasField(inputField.getName())) {
                builder.field(inputField);
            }
        }));
        return this.directivesObserve(buildCtx, builder.build());
    }

    private GraphQLInputObjectField buildInputField(BuildContext buildCtx, InputValueDefinition fieldDef) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        fieldBuilder.definition(buildCtx.isCaptureAstDefinitions() ? fieldDef : null);
        fieldBuilder.name(fieldDef.getName());
        fieldBuilder.description(this.buildDescription(buildCtx, fieldDef, fieldDef.getDescription()));
        fieldBuilder.deprecate(this.buildDeprecationReason(fieldDef.getDirectives()));
        fieldBuilder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, fieldDef.getType());
        fieldBuilder.type(inputType);
        Value defaultValue = fieldDef.getDefaultValue();
        if (defaultValue != null) {
            fieldBuilder.defaultValueLiteral(defaultValue);
        }
        fieldBuilder.withDirectives(this.buildAppliedDirectives(buildCtx, fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        return this.directivesObserve(buildCtx, fieldBuilder.build());
    }

    GraphQLEnumType buildEnumType(BuildContext buildCtx, EnumTypeDefinition typeDefinition) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<EnumTypeExtensionDefinition> extensions = this.enumTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        EnumValuesProvider enumValuesProvider = buildCtx.getWiring().getEnumValuesProviders().get(typeDefinition.getName());
        typeDefinition.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            builder.value(enumValueDefinition);
        });
        extensions.forEach(extension -> extension.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            if (!builder.hasValue(enumValueDefinition.getName())) {
                builder.value(enumValueDefinition);
            }
        }));
        builder.withDirectives(this.buildAppliedDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.ENUM, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        return this.directivesObserve(buildCtx, builder.build());
    }

    private GraphQLEnumValueDefinition buildEnumValue(BuildContext buildCtx, EnumTypeDefinition typeDefinition, EnumValuesProvider enumValuesProvider, EnumValueDefinition evd) {
        Object value;
        String description2 = this.buildDescription(buildCtx, evd, evd.getDescription());
        String deprecation = this.buildDeprecationReason(evd.getDirectives());
        if (enumValuesProvider != null) {
            value = enumValuesProvider.getValue(evd.getName());
            Assert.assertNotNull(value, () -> String.format("EnumValuesProvider for %s returned null for %s", typeDefinition.getName(), evd.getName()));
        } else {
            value = evd.getName();
        }
        GraphQLEnumValueDefinition enumValueDefinition = GraphQLEnumValueDefinition.newEnumValueDefinition().name(evd.getName()).value(value).description(description2).deprecationReason(deprecation).definition(buildCtx.isCaptureAstDefinitions() ? evd : null).comparatorRegistry(buildCtx.getComparatorRegistry()).withDirectives(this.buildAppliedDirectives(buildCtx, evd.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ENUM_VALUE, buildCtx.getDirectives(), buildCtx.getComparatorRegistry())).build();
        return this.directivesObserve(buildCtx, enumValueDefinition);
    }

    GraphQLScalarType buildScalar(BuildContext buildCtx, ScalarTypeDefinition typeDefinition) {
        List<ScalarTypeExtensionDefinition> extensions;
        ScalarWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        GraphQLScalarType scalar = wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, typeDefinition, extensions = this.scalarTypeExtensions(typeDefinition, buildCtx))) ? wiringFactory.getScalar(environment) : buildCtx.getWiring().getScalars().get(typeDefinition.getName());
        if (!ScalarInfo.isGraphqlSpecifiedScalar(scalar)) {
            String description2 = this.getScalarDesc(scalar, typeDefinition);
            scalar = scalar.transform(builder -> builder.description(description2).definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null).comparatorRegistry(buildCtx.getComparatorRegistry()).specifiedByUrl(this.getSpecifiedByUrl(typeDefinition, extensions)).withDirectives(this.buildAppliedDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.SCALAR, buildCtx.getDirectives(), buildCtx.getComparatorRegistry())));
        }
        return this.directivesObserve(buildCtx, scalar);
    }

    private String getScalarDesc(GraphQLScalarType scalar, ScalarTypeDefinition typeDefinition) {
        if (scalar.getDescription() != null && !scalar.getDescription().trim().isEmpty()) {
            return scalar.getDescription();
        }
        if (typeDefinition.getDescription() != null) {
            return typeDefinition.getDescription().getContent();
        }
        return "";
    }

    String getSpecifiedByUrl(ScalarTypeDefinition scalarTypeDefinition, List<ScalarTypeExtensionDefinition> extensions) {
        ArrayList<Directive> allDirectives = new ArrayList<Directive>(scalarTypeDefinition.getDirectives());
        extensions.forEach(extension -> allDirectives.addAll(extension.getDirectives()));
        Optional<Directive> specifiedByDirective = FpKit.findOne(allDirectives, directiveDefinition -> directiveDefinition.getName().equals(Directives.SpecifiedByDirective.getName()));
        if (!specifiedByDirective.isPresent()) {
            return null;
        }
        Argument urlArgument = specifiedByDirective.get().getArgument("url");
        StringValue url = (StringValue)urlArgument.getValue();
        return url.getValue();
    }

    private TypeResolver getTypeResolverForInterface(BuildContext buildCtx, InterfaceTypeDefinition interfaceType) {
        TypeResolver typeResolver;
        InterfaceWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new InterfaceWiringEnvironment(typeRegistry, interfaceType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, () -> "The WiringFactory indicated it provides a interface type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(interfaceType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private TypeResolver getTypeResolverForUnion(BuildContext buildCtx, UnionTypeDefinition unionType) {
        TypeResolver typeResolver;
        UnionWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new UnionWiringEnvironment(typeRegistry, unionType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, () -> "The WiringFactory indicated it union provides a type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(unionType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    GraphQLDirective[] buildAppliedDirectives(BuildContext buildCtx, List<Directive> directives, List<Directive> extensionDirectives, Introspection.DirectiveLocation directiveLocation, Set<GraphQLDirective> runtimeDirectives, GraphqlTypeComparatorRegistry comparatorRegistry) {
        GraphQLDirective gqlDirective;
        directives = Optional.ofNullable(directives).orElse(Collections.emptyList());
        extensionDirectives = Optional.ofNullable(extensionDirectives).orElse(Collections.emptyList());
        LinkedHashSet<String> previousNames = new LinkedHashSet<String>();
        ArrayList<GraphQLDirective> output = new ArrayList<GraphQLDirective>();
        for (Directive directive : directives) {
            gqlDirective = this.buildAppliedDirective(buildCtx, directive, directiveLocation, runtimeDirectives, comparatorRegistry, previousNames);
            output.add(gqlDirective);
        }
        for (Directive directive : extensionDirectives) {
            gqlDirective = this.buildAppliedDirective(buildCtx, directive, directiveLocation, runtimeDirectives, comparatorRegistry, previousNames);
            output.add(gqlDirective);
        }
        return output.toArray(new GraphQLDirective[0]);
    }

    private void buildInterfaceTypeInterfaces(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition, GraphQLInterfaceType.Builder builder, List<InterfaceTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    private GraphQLObjectType buildOperation(BuildContext buildCtx, OperationTypeDefinition operation) {
        TypeName type = operation.getTypeName();
        return (GraphQLObjectType)this.buildOutputType(buildCtx, type);
    }

    GraphQLInterfaceType buildInterfaceType(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition) {
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InterfaceTypeExtensionDefinition> extensions = this.interfaceTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        builder.withDirectives(this.buildAppliedDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildInterfaceTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        GraphQLInterfaceType interfaceType = builder.build();
        if (!buildCtx.getCodeRegistry().hasTypeResolver(interfaceType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForInterface(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(interfaceType, typeResolver);
        }
        return this.directivesObserve(buildCtx, interfaceType);
    }

    GraphQLObjectType buildObjectType(BuildContext buildCtx, ObjectTypeDefinition typeDefinition) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<ObjectTypeExtensionDefinition> extensions = this.objectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        builder.withDirectives(this.buildAppliedDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildObjectTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        return this.directivesObserve(buildCtx, builder.build());
    }

    private void buildObjectTypeInterfaces(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<ObjectTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    GraphQLUnionType buildUnionType(BuildContext buildCtx, UnionTypeDefinition typeDefinition) {
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<UnionTypeExtensionDefinition> extensions = this.unionTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        typeDefinition.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type)mt);
            if (outputType instanceof GraphQLTypeReference) {
                builder.possibleType((GraphQLTypeReference)outputType);
            } else {
                builder.possibleType((GraphQLObjectType)outputType);
            }
        });
        builder.withDirectives(this.buildAppliedDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.UNION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        extensions.forEach(extension -> extension.getMemberTypes().forEach(mt -> {
            GraphQLNamedOutputType outputType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)mt);
            if (!builder.containType(outputType.getName())) {
                if (outputType instanceof GraphQLTypeReference) {
                    builder.possibleType((GraphQLTypeReference)outputType);
                } else {
                    builder.possibleType((GraphQLObjectType)outputType);
                }
            }
        }));
        GraphQLUnionType unionType = builder.build();
        if (!buildCtx.getCodeRegistry().hasTypeResolver(unionType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForUnion(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(unionType, typeResolver);
        }
        return this.directivesObserve(buildCtx, unionType);
    }

    private <T extends GraphQLOutputType> T buildOutputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLOutputType outputType = buildCtx.hasOutputType(typeDefinition);
        if (outputType != null) {
            return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (T)((GraphQLOutputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName())));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof ObjectTypeDefinition) {
            outputType = this.buildObjectType(buildCtx, (ObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof InterfaceTypeDefinition) {
            outputType = this.buildInterfaceType(buildCtx, (InterfaceTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof UnionTypeDefinition) {
            outputType = this.buildUnionType(buildCtx, (UnionTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            outputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            outputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnOutputTypeError(rawType, typeDefinition);
        }
        buildCtx.putOutputType((GraphQLNamedOutputType)outputType);
        buildCtx.pop();
        return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
    }

    GraphQLFieldDefinition buildField(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? fieldDef : null);
        builder.name(fieldDef.getName());
        builder.description(this.buildDescription(buildCtx, fieldDef, fieldDef.getDescription()));
        builder.deprecate(this.buildDeprecationReason(fieldDef.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLDirective[] directives = this.buildAppliedDirectives(buildCtx, fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.FIELD_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        builder.withDirectives(directives);
        fieldDef.getInputValueDefinitions().forEach(inputValueDefinition -> builder.argument(this.buildArgument(buildCtx, (InputValueDefinition)inputValueDefinition)));
        Object fieldType = this.buildOutputType(buildCtx, fieldDef.getType());
        builder.type((GraphQLOutputType)fieldType);
        GraphQLFieldDefinition fieldDefinition = builder.build();
        FieldCoordinates coordinates = FieldCoordinates.coordinates(parentType.getName(), fieldDefinition.getName());
        if (!buildCtx.getCodeRegistry().hasDataFetcher(coordinates)) {
            DataFetcherFactory<?> dataFetcherFactory = this.buildDataFetcherFactory(buildCtx, parentType, fieldDef, (GraphQLOutputType)fieldType, Arrays.asList(directives));
            buildCtx.getCodeRegistry().dataFetcher(coordinates, dataFetcherFactory);
        }
        return this.directivesObserve(buildCtx, fieldDefinition);
    }

    private DataFetcherFactory<?> buildDataFetcherFactory(BuildContext buildCtx, TypeDefinition<?> parentType, FieldDefinition fieldDef, GraphQLOutputType fieldType, List<GraphQLDirective> directives) {
        DataFetcherFactory dataFetcherFactory;
        String fieldName = fieldDef.getName();
        String parentTypeName = parentType.getName();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        GraphQLCodeRegistry.Builder codeRegistry = buildCtx.getCodeRegistry();
        FieldWiringEnvironment wiringEnvironment = new FieldWiringEnvironment(typeRegistry, parentType, fieldDef, fieldType, directives);
        if (wiringFactory.providesDataFetcherFactory(wiringEnvironment)) {
            dataFetcherFactory = wiringFactory.getDataFetcherFactory(wiringEnvironment);
            Assert.assertNotNull(dataFetcherFactory, () -> "The WiringFactory indicated it provides a data fetcher factory but then returned null");
        } else {
            DataFetcher dataFetcher;
            if (wiringFactory.providesDataFetcher(wiringEnvironment)) {
                dataFetcher = wiringFactory.getDataFetcher(wiringEnvironment);
                Assert.assertNotNull(dataFetcher, () -> "The WiringFactory indicated it provides a data fetcher but then returned null");
            } else {
                dataFetcher = runtimeWiring.getDataFetcherForType(parentTypeName).get(fieldName);
                if (dataFetcher == null && (dataFetcher = runtimeWiring.getDefaultDataFetcherForType(parentTypeName)) == null && (dataFetcher = wiringFactory.getDefaultDataFetcher(wiringEnvironment)) == null) {
                    DataFetcherFactory<?> codeRegistryDFF = codeRegistry.getDefaultDataFetcherFactory();
                    if (codeRegistryDFF != null) {
                        return codeRegistryDFF;
                    }
                    dataFetcher = this.dataFetcherOfLastResort(wiringEnvironment);
                }
            }
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
        }
        return dataFetcherFactory;
    }

    GraphQLArgument buildArgument(BuildContext buildCtx, InputValueDefinition valueDefinition) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? valueDefinition : null);
        builder.name(valueDefinition.getName());
        builder.description(this.buildDescription(buildCtx, valueDefinition, valueDefinition.getDescription()));
        builder.deprecate(this.buildDeprecationReason(valueDefinition.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, valueDefinition.getType());
        builder.type(inputType);
        Value defaultValue = valueDefinition.getDefaultValue();
        if (defaultValue != null) {
            builder.defaultValueLiteral(defaultValue);
        }
        builder.withDirectives(this.buildAppliedDirectives(buildCtx, valueDefinition.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ARGUMENT_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        return this.directivesObserve(buildCtx, builder.build());
    }

    void buildOperations(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType query;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        Map<String, OperationTypeDefinition> operationTypeDefs = buildCtx.operationTypeDefs;
        Optional<OperationTypeDefinition> queryOperation = this.getOperationNamed("query", operationTypeDefs);
        if (!queryOperation.isPresent()) {
            TypeDefinition queryTypeDef = typeRegistry.getType("Query").get();
            query = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(queryTypeDef.getName()).build());
        } else {
            query = this.buildOperation(buildCtx, queryOperation.get());
        }
        schemaBuilder.query(query);
        Optional<OperationTypeDefinition> mutationOperation = this.getOperationNamed("mutation", operationTypeDefs);
        if (!mutationOperation.isPresent()) {
            Optional<TypeDefinition> mutationTypeDef = typeRegistry.getType("Mutation");
            if (mutationTypeDef.isPresent()) {
                GraphQLObjectType mutation = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(mutationTypeDef.get().getName()).build());
                schemaBuilder.mutation(mutation);
            }
        } else {
            GraphQLObjectType mutation = this.buildOperation(buildCtx, mutationOperation.get());
            schemaBuilder.mutation(mutation);
        }
        Optional<OperationTypeDefinition> subscriptionOperation = this.getOperationNamed("subscription", operationTypeDefs);
        if (!subscriptionOperation.isPresent()) {
            Optional<TypeDefinition> subscriptionTypeDef = typeRegistry.getType("Subscription");
            if (subscriptionTypeDef.isPresent()) {
                GraphQLObjectType subscription = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(subscriptionTypeDef.get().getName()).build());
                schemaBuilder.subscription(subscription);
            }
        } else {
            GraphQLObjectType subscription = this.buildOperation(buildCtx, subscriptionOperation.get());
            schemaBuilder.subscription(subscription);
        }
    }

    void buildSchemaDirectivesAndExtensions(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        List<Directive> schemaDirectiveList = SchemaExtensionsChecker.gatherSchemaDirectives(typeRegistry);
        Set<GraphQLDirective> runtimeDirectives = buildCtx.getDirectives();
        schemaBuilder.withSchemaDirectives(this.buildAppliedDirectives(buildCtx, schemaDirectiveList, Collections.emptyList(), Introspection.DirectiveLocation.SCHEMA, runtimeDirectives, buildCtx.getComparatorRegistry()));
        schemaBuilder.definition(buildCtx.isCaptureAstDefinitions() ? (SchemaDefinition)typeRegistry.schemaDefinition().orElse(null) : null);
        schemaBuilder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? typeRegistry.getSchemaExtensionDefinitions() : Collections.emptyList());
    }

    List<InputObjectTypeExtensionDefinition> inputObjectTypeExtensions(InputObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().inputObjectTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<EnumTypeExtensionDefinition> enumTypeExtensions(EnumTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().enumTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<ScalarTypeExtensionDefinition> scalarTypeExtensions(ScalarTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().scalarTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<InterfaceTypeExtensionDefinition> interfaceTypeExtensions(InterfaceTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().interfaceTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<ObjectTypeExtensionDefinition> objectTypeExtensions(ObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().objectTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<UnionTypeExtensionDefinition> unionTypeExtensions(UnionTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().unionTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    Set<GraphQLType> buildAdditionalTypes(BuildContext buildCtx) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        Set<String> detachedTypeNames = this.getDetachedTypeNames(buildCtx);
        LinkedHashSet<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
        typeRegistry.types().values().stream().filter(typeDefinition -> detachedTypeNames.contains(typeDefinition.getName())).forEach(typeDefinition -> {
            TypeName typeName = TypeName.newTypeName().name(typeDefinition.getName()).build();
            if (typeDefinition instanceof InputObjectTypeDefinition) {
                if (buildCtx.hasInputType((TypeDefinition)typeDefinition) == null) {
                    buildCtx.putInputType((GraphQLNamedInputType)this.buildInputType(buildCtx, typeName));
                }
                additionalTypes.add((GraphQLType)buildCtx.inputGTypes.get(typeDefinition.getName()));
            } else {
                if (buildCtx.hasOutputType((TypeDefinition)typeDefinition) == null) {
                    buildCtx.putOutputType((GraphQLNamedOutputType)this.buildOutputType(buildCtx, typeName));
                }
                additionalTypes.add((GraphQLType)buildCtx.outputGTypes.get(typeDefinition.getName()));
            }
        });
        typeRegistry.scalars().values().stream().filter(typeDefinition -> detachedTypeNames.contains(typeDefinition.getName())).forEach(scalarTypeDefinition -> {
            if (ScalarInfo.isGraphqlSpecifiedScalar(scalarTypeDefinition.getName())) {
                return;
            }
            if (buildCtx.hasInputType((TypeDefinition)scalarTypeDefinition) == null && buildCtx.hasOutputType((TypeDefinition)scalarTypeDefinition) == null) {
                buildCtx.putOutputType(this.buildScalar(buildCtx, (ScalarTypeDefinition)scalarTypeDefinition));
            }
            if (buildCtx.hasInputType((TypeDefinition)scalarTypeDefinition) != null) {
                additionalTypes.add((GraphQLType)buildCtx.inputGTypes.get(scalarTypeDefinition.getName()));
            } else if (buildCtx.hasOutputType((TypeDefinition)scalarTypeDefinition) != null) {
                additionalTypes.add((GraphQLType)buildCtx.outputGTypes.get(scalarTypeDefinition.getName()));
            }
        });
        return additionalTypes;
    }

    private Set<String> getDetachedTypeNames(BuildContext buildCtx) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        HashSet connectedTypes = new HashSet(buildCtx.inputGTypes.keySet());
        connectedTypes.addAll(buildCtx.outputGTypes.keySet());
        HashSet<String> allTypeNames = new HashSet<String>(typeRegistry.types().keySet());
        HashSet<String> scalars = new HashSet<String>(typeRegistry.scalars().keySet());
        allTypeNames.addAll(scalars);
        HashSet<String> detachedTypeNames = new HashSet<String>(allTypeNames);
        detachedTypeNames.removeAll(connectedTypes);
        return detachedTypeNames;
    }

    Set<GraphQLDirective> buildAdditionalDirectiveDefinitions(BuildContext buildCtx) {
        LinkedHashSet<GraphQLDirective> additionalDirectives = new LinkedHashSet<GraphQLDirective>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        for (DirectiveDefinition directiveDefinition : typeRegistry.getDirectiveDefinitions().values()) {
            Function<Type, GraphQLInputType> inputTypeFactory = inputType -> this.buildInputType(buildCtx, (Type)inputType);
            GraphQLDirective directive = this.buildDirectiveDefinitionFromAst(buildCtx, directiveDefinition, inputTypeFactory);
            buildCtx.addDirectiveDefinition(directive);
            additionalDirectives.add(directive);
        }
        return additionalDirectives;
    }

    void addDirectivesIncludedByDefault(TypeDefinitionRegistry typeRegistry) {
        typeRegistry.add(Directives.DEPRECATED_DIRECTIVE_DEFINITION);
        typeRegistry.add(Directives.SPECIFIED_BY_DIRECTIVE_DEFINITION);
    }

    private Optional<OperationTypeDefinition> getOperationNamed(String name, Map<String, OperationTypeDefinition> operationTypeDefs) {
        return Optional.ofNullable(operationTypeDefs.get(name));
    }

    private DataFetcher<?> dataFetcherOfLastResort(FieldWiringEnvironment environment) {
        String fieldName = environment.getFieldDefinition().getName();
        return new PropertyDataFetcher(fieldName);
    }

    private List<Directive> directivesOf(List<? extends TypeDefinition> typeDefinitions) {
        return typeDefinitions.stream().map(DirectivesContainer::getDirectives).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private <T extends GraphQLDirectiveContainer> T directivesObserve(BuildContext buildCtx, T directiveContainer) {
        if (!buildCtx.directiveWiringRequired) {
            boolean requiresWiring = SchemaGeneratorDirectiveHelper.schemaDirectiveWiringIsRequired(directiveContainer, buildCtx.getTypeRegistry(), buildCtx.getWiring());
            buildCtx.directiveWiringRequired |= requiresWiring;
        }
        return directiveContainer;
    }

    static class BuildContext {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring wiring;
        private final Deque<String> typeStack = new ArrayDeque<String>();
        private final Map<String, GraphQLOutputType> outputGTypes = new LinkedHashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLInputType> inputGTypes = new LinkedHashMap<String, GraphQLInputType>();
        private final Set<GraphQLDirective> directives = new LinkedHashSet<GraphQLDirective>();
        private final GraphQLCodeRegistry.Builder codeRegistry;
        public final Map<String, OperationTypeDefinition> operationTypeDefs;
        public final SchemaGenerator.Options options;
        public boolean directiveWiringRequired;

        BuildContext(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring, Map<String, OperationTypeDefinition> operationTypeDefinitions, SchemaGenerator.Options options) {
            this.typeRegistry = typeRegistry;
            this.wiring = wiring;
            this.codeRegistry = GraphQLCodeRegistry.newCodeRegistry(wiring.getCodeRegistry());
            this.operationTypeDefs = operationTypeDefinitions;
            this.options = options;
            this.directiveWiringRequired = false;
        }

        public boolean isDirectiveWiringRequired() {
            return this.directiveWiringRequired;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        TypeDefinition getTypeDefinition(Type type) {
            Optional<TypeDefinition> optionalTypeDefinition = this.typeRegistry.getType(type);
            return optionalTypeDefinition.orElseThrow(() -> new AssertException(String.format(" type definition for type '%s' not found", type)));
        }

        boolean stackContains(TypeInfo typeInfo) {
            return this.typeStack.contains(typeInfo.getName());
        }

        void push(TypeInfo typeInfo) {
            this.typeStack.push(typeInfo.getName());
        }

        void pop() {
            this.typeStack.pop();
        }

        GraphQLOutputType hasOutputType(TypeDefinition typeDefinition) {
            return this.outputGTypes.get(typeDefinition.getName());
        }

        GraphQLInputType hasInputType(TypeDefinition typeDefinition) {
            return this.inputGTypes.get(typeDefinition.getName());
        }

        void putOutputType(GraphQLNamedOutputType outputType) {
            this.outputGTypes.put(outputType.getName(), outputType);
            if (outputType instanceof GraphQLInputType) {
                this.inputGTypes.put(outputType.getName(), (GraphQLInputType)((Object)outputType));
            }
        }

        void putInputType(GraphQLNamedInputType inputType) {
            this.inputGTypes.put(inputType.getName(), inputType);
            if (inputType instanceof GraphQLOutputType) {
                this.outputGTypes.put(inputType.getName(), (GraphQLOutputType)((Object)inputType));
            }
        }

        RuntimeWiring getWiring() {
            return this.wiring;
        }

        GraphqlTypeComparatorRegistry getComparatorRegistry() {
            return this.wiring.getComparatorRegistry();
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }

        public void addDirectiveDefinition(GraphQLDirective directive) {
            this.directives.add(directive);
        }

        public void addDirectives(Set<GraphQLDirective> directives) {
            this.directives.addAll(directives);
        }

        public Set<GraphQLDirective> getDirectives() {
            return this.directives;
        }

        public boolean isCaptureAstDefinitions() {
            return this.options.isCaptureAstDefinitions();
        }
    }
}

