/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.VersionRestClient;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.VersionRelatedIssuesCount;
import com.atlassian.jira.rest.client.domain.input.VersionInput;
import com.atlassian.jira.rest.client.domain.input.VersionPosition;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import com.atlassian.jira.rest.client.internal.json.VersionRelatedIssueCountJsonParser;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.VersionInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.VersionPositionInputGenerator;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseyVersionRestClient
extends AbstractJerseyRestClient
implements VersionRestClient {
    private final URI versionRootUri;

    public JerseyVersionRestClient(URI baseUri, ApacheHttpClient client) {
        super(baseUri, client);
        this.versionRootUri = UriBuilder.fromUri((URI)baseUri).path("version").build(new Object[0]);
    }

    @Override
    public Version createVersion(VersionInput version, ProgressMonitor progressMonitor) {
        return this.postAndParse(this.versionRootUri, AbstractJerseyRestClient.InputGeneratorCallable.create(new VersionInputJsonGenerator(), version), new VersionJsonParser(), progressMonitor);
    }

    @Override
    public Version updateVersion(URI versionUri, VersionInput version, ProgressMonitor progressMonitor) {
        return this.putAndParse(versionUri, AbstractJerseyRestClient.InputGeneratorCallable.create(new VersionInputJsonGenerator(), version), new VersionJsonParser(), progressMonitor);
    }

    @Override
    public void removeVersion(URI versionUri, @Nullable URI moveFixIssuesToVersionUri, @Nullable URI moveAffectedIssuesToVersionUri, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)versionUri);
        if (moveFixIssuesToVersionUri != null) {
            uriBuilder.queryParam("moveFixIssuesTo", new Object[]{moveFixIssuesToVersionUri});
        }
        if (moveAffectedIssuesToVersionUri != null) {
            uriBuilder.queryParam("moveAffectedIssuesTo", new Object[]{moveAffectedIssuesToVersionUri});
        }
        this.delete(uriBuilder.build(new Object[0]), progressMonitor);
    }

    @Override
    public Version getVersion(URI versionUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(versionUri, new VersionJsonParser(), progressMonitor);
    }

    @Override
    public VersionRelatedIssuesCount getVersionRelatedIssuesCount(URI versionUri, ProgressMonitor progressMonitor) {
        URI relatedIssueCountsUri = UriBuilder.fromUri((URI)versionUri).path("relatedIssueCounts").build(new Object[0]);
        return this.getAndParse(relatedIssueCountsUri, new VersionRelatedIssueCountJsonParser(), progressMonitor);
    }

    @Override
    public int getNumUnresolvedIssues(URI versionUri, ProgressMonitor progressMonitor) {
        URI unresolvedIssueCountUri = UriBuilder.fromUri((URI)versionUri).path("unresolvedIssueCount").build(new Object[0]);
        return this.getAndParse(unresolvedIssueCountUri, new JsonObjectParser<Integer>(){

            @Override
            public Integer parse(JSONObject json) throws JSONException {
                return json.getInt("issuesUnresolvedCount");
            }
        }, progressMonitor);
    }

    @Override
    public Version moveVersionAfter(URI versionUri, URI afterVersionUri, ProgressMonitor progressMonitor) {
        URI moveUri = this.getMoveVersionUri(versionUri);
        return this.postAndParse(moveUri, AbstractJerseyRestClient.InputGeneratorCallable.create(new JsonGenerator<URI>(){

            @Override
            public JSONObject generate(URI uri) throws JSONException {
                JSONObject res = new JSONObject();
                res.put("after", (Object)uri);
                return res;
            }
        }, afterVersionUri), new VersionJsonParser(), progressMonitor);
    }

    @Override
    public Version moveVersion(URI versionUri, VersionPosition versionPosition, ProgressMonitor progressMonitor) {
        URI moveUri = this.getMoveVersionUri(versionUri);
        return this.postAndParse(moveUri, AbstractJerseyRestClient.InputGeneratorCallable.create(new VersionPositionInputGenerator(), versionPosition), new VersionJsonParser(), progressMonitor);
    }

    private URI getMoveVersionUri(URI versionUri) {
        return UriBuilder.fromUri((URI)versionUri).path("move").build(new Object[0]);
    }
}

