/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TransitionJsonParserV5
implements JsonObjectParser<Transition> {
    private final TransitionFieldJsonParser transitionFieldJsonParser = new TransitionFieldJsonParser();

    @Override
    public Transition parse(JSONObject json) throws JSONException {
        int id = json.getInt("id");
        String name = json.getString("name");
        JSONObject fieldsObj = json.getJSONObject("fields");
        Iterator keys = fieldsObj.keys();
        ArrayList fields = Lists.newArrayList();
        while (keys.hasNext()) {
            String fieldId = keys.next().toString();
            fields.add(this.transitionFieldJsonParser.parse(fieldsObj.getJSONObject(fieldId), fieldId));
        }
        return new Transition(name, id, fields);
    }

    public static class TransitionFieldJsonParser {
        public Transition.Field parse(JSONObject json, String id) throws JSONException {
            boolean isRequired = json.getBoolean("required");
            String type = json.getJSONObject("schema").getString("type");
            return new Transition.Field(id, isRequired, type);
        }
    }
}

