/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.Topological;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J!\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\bj\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/graph/ShortestPath;", "N", "", "graph", "Lcom/google/common/graph/Graph;", "source", "(Lcom/google/common/graph/Graph;Ljava/lang/Object;)V", "distTo", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "edgeTo", "Lcom/google/common/graph/EndpointPair;", "Ljava/lang/Object;", "edgesTo", "", "other", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "hasPathTo", "", "(Ljava/lang/Object;)Z", "pathTo", "relax", "", "target", "(Ljava/lang/Object;Ljava/lang/Object;)V", "graph-support"})
public final class ShortestPath<N> {
    @NotNull
    private final N source;
    @NotNull
    private final LinkedHashMap<N, Float> distTo;
    @NotNull
    private final LinkedHashMap<N, EndpointPair<N>> edgeTo;

    public ShortestPath(@NotNull Graph<N> graph, @NotNull N source) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
        this.distTo = new LinkedHashMap();
        this.edgeTo = new LinkedHashMap();
        for (Object node : graph.nodes()) {
            Map map = this.distTo;
            Intrinsics.checkNotNullExpressionValue(node, (String)"node");
            map.put(node, Float.valueOf(Float.POSITIVE_INFINITY));
        }
        ((Map)this.distTo).put(this.source, Float.valueOf(0.0f));
        Topological<N> top = new Topological<N>(graph, this.source);
        for (N from : top.getOrder()) {
            for (Object to : graph.successors(from)) {
                Intrinsics.checkNotNullExpressionValue(to, (String)"to");
                this.relax(from, to);
            }
        }
    }

    public final boolean hasPathTo(@NotNull N other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Float f = this.distTo.get(other);
        if (f == null) {
            return false;
        }
        float dist = ((Number)f).floatValue();
        return dist < Float.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<N> pathTo(@NotNull N other) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (!this.hasPathTo(other)) {
            return CollectionsKt.emptyList();
        }
        Iterable<EndpointPair<N>> iterable = this.edgesTo(other);
        Object[] objectArray = new Object[]{this.source};
        Collection destination$iv = CollectionsKt.mutableListOf((Object[])objectArray);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            EndpointPair endpointPair = (EndpointPair)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.target());
        }
        return (Iterable)objectArray;
    }

    private final Iterable<EndpointPair<N>> edgesTo(N other) {
        if (!this.hasPathTo(other)) {
            return CollectionsKt.emptyList();
        }
        ArrayDeque<EndpointPair<N>> path = new ArrayDeque<EndpointPair<N>>();
        EndpointPair<N> e = this.edgeTo.get(other);
        while (e != null) {
            path.push(e);
            e = this.edgeTo.get(e.source());
        }
        return path;
    }

    private final void relax(N source, N target) {
        Float f = this.distTo.get(target);
        Intrinsics.checkNotNull((Object)f);
        float f2 = ((Number)f).floatValue();
        Float f3 = this.distTo.get(source);
        Intrinsics.checkNotNull((Object)f3);
        if (f2 > ((Number)f3).floatValue() + 1.0f) {
            Map map = this.distTo;
            Float f4 = this.distTo.get(source);
            Intrinsics.checkNotNull((Object)f4);
            map.put(target, Float.valueOf(((Number)f4).floatValue() + 1.0f));
            Map map2 = this.edgeTo;
            EndpointPair endpointPair = EndpointPair.ordered(source, target);
            Intrinsics.checkNotNullExpressionValue((Object)endpointPair, (String)"ordered(source, target)");
            EndpointPair endpointPair2 = endpointPair;
            map2.put(target, endpointPair2);
        }
    }
}

