/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import io.netty.buffer.ByteBuf;
import io.netty.util.Version;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import reactor.netty.Connection;
import reactor.netty.channel.ChannelOperations;

public final class NettyUtility {
    private static final ClientLogger LOGGER = new ClientLogger(NettyUtility.class);
    private static final String PROPERTIES_FILE_NAME = "azure-core-http-netty.properties";
    private static final String NETTY_VERSION_PROPERTY = "netty-version";
    private static final String NETTY_TCNATIVE_VERSION_PROPERTY = "netty-tcnative-version";
    private static final List<String> REQUIRED_NETTY_VERSION_ARTIFACTS = Arrays.asList("netty-common", "netty-handler", "netty-handler-proxy", "netty-buffer", "netty-codec", "netty-codec-http", "netty-codec-http2");
    private static final List<String> OPTIONAL_NETTY_VERSION_ARTIFACTS = Arrays.asList("netty-transport-native-unix-common", "netty-transport-native-epoll", "netty-transport-native-kqueue");
    private static final List<String> NETTY_TCNATIVE_VERSION_ARTIFACTS = Collections.singletonList("netty-tcnative-boringssl-static");
    static final String NETTY_VERSION_MISMATCH_LOG = "The versions of Netty being used are not aligned. ";

    public static ByteBuffer deepCopyBuffer(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.getBytes(byteBuf.readerIndex(), bytes);
        return ByteBuffer.wrap(bytes);
    }

    public static void closeConnection(Connection reactorNettyConnection) {
        if (reactorNettyConnection instanceof ChannelOperations) {
            ChannelOperations channelOperations = (ChannelOperations)reactorNettyConnection;
            if (!channelOperations.isInboundDisposed()) {
                channelOperations.channel().eventLoop().execute(() -> ((ChannelOperations)channelOperations).discard());
            }
        } else if (!reactorNettyConnection.isDisposed()) {
            reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)reactorNettyConnection).dispose());
        }
    }

    public static void validateNettyVersions() {
        if (LOGGER.canLogAtLevel(LogLevel.INFORMATIONAL)) {
            NettyUtility.validateNettyVersions(arg_0 -> ((ClientLogger)LOGGER).info(arg_0));
        }
    }

    static void validateNettyVersions(Consumer<String> logger) {
        Version version;
        Map pomVersions = CoreUtils.getProperties((String)PROPERTIES_FILE_NAME);
        String nettyVersion = (String)pomVersions.get(NETTY_VERSION_PROPERTY);
        String nettyTcnativeVersion = (String)pomVersions.get(NETTY_TCNATIVE_VERSION_PROPERTY);
        Map nettyVersions = Version.identify();
        ArrayList<String> versionInformation = new ArrayList<String>(11);
        HashSet<String> nonNativeNettyVersions = new HashSet<String>();
        for (String artifact : REQUIRED_NETTY_VERSION_ARTIFACTS) {
            version = (Version)nettyVersions.get(artifact);
            if (version == null) {
                versionInformation.add("'io.netty:" + artifact + "' (not found and is required)");
                nonNativeNettyVersions.add("unknown");
                continue;
            }
            versionInformation.add("'io.netty:" + artifact + "' version: " + version.artifactVersion());
            nonNativeNettyVersions.add(version.artifactVersion());
        }
        for (String artifact : OPTIONAL_NETTY_VERSION_ARTIFACTS) {
            version = (Version)nettyVersions.get(artifact);
            if (version == null) continue;
            versionInformation.add("'io.netty:" + artifact + "' version: " + version.artifactVersion());
            nonNativeNettyVersions.add(version.artifactVersion());
        }
        for (String artifact : NETTY_TCNATIVE_VERSION_ARTIFACTS) {
            version = (Version)nettyVersions.get(artifact);
            if (version == null) continue;
            versionInformation.add("'io.netty:" + artifact + "' version: " + version.artifactVersion());
        }
        String versionInformationString = CoreUtils.stringJoin((String)", ", versionInformation);
        StringBuilder stringBuilder = new StringBuilder().append("The following is Netty version information that was found on the classpath: ").append(versionInformationString).append(". ");
        if (nonNativeNettyVersions.size() > 1) {
            stringBuilder.append(NETTY_VERSION_MISMATCH_LOG);
        }
        stringBuilder.append("The version of azure-core-http-netty being used was built with Netty version ").append(nettyVersion).append(" and Netty Tcnative version ").append(nettyTcnativeVersion).append(". If your application runs without issue this message can be ignored, otherwise please align the Netty versions used in your application. For more information, see https://aka.ms/azsdk/java/dependency/troubleshoot.");
        logger.accept(stringBuilder.toString());
    }

    private NettyUtility() {
    }
}

