/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ResponseTimeoutHandler
extends ChannelInboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureResponseTimeoutHandler";
    private static final String RESPONSE_TIMED_OUT_MESSAGE = "Channel response timed out after %d milliseconds.";
    private final long timeoutMillis;
    private ScheduledFuture<?> responseTimeoutWatcher;

    public ResponseTimeoutHandler(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.timeoutMillis > 0L) {
            this.responseTimeoutWatcher = ctx.executor().schedule(() -> this.responseTimedOut(ctx), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.responseTimeoutWatcher != null && !this.responseTimeoutWatcher.isDone()) {
            this.responseTimeoutWatcher.cancel(false);
            this.responseTimeoutWatcher = null;
        }
    }

    private void responseTimedOut(ChannelHandlerContext ctx) {
        ctx.fireExceptionCaught((Throwable)new TimeoutException(String.format(RESPONSE_TIMED_OUT_MESSAGE, this.timeoutMillis)));
    }
}

