/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.implementation.ChallengeHolder;
import com.azure.core.http.netty.implementation.HttpProxyExceptionHandler;
import com.azure.core.http.netty.implementation.HttpProxyHandler;
import com.azure.core.util.AuthorizationChallengeHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import reactor.netty.ConnectionObserver;

public class DeferredHttpProxyProvider
implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
    private final AuthorizationChallengeHandler challengeHandler;
    private final AtomicReference<ChallengeHolder> proxyChallengeHolderReference;
    private final InetSocketAddress proxyAddress;
    private final String username;
    private final String password;
    private final String nonProxyHosts;
    private final Pattern nonProxyHostsPattern;

    public DeferredHttpProxyProvider(AuthorizationChallengeHandler challengeHandler, AtomicReference<ChallengeHolder> proxyChallengeHolderReference, ProxyOptions proxyOptions) {
        this.challengeHandler = challengeHandler;
        this.proxyChallengeHolderReference = proxyChallengeHolderReference;
        this.proxyAddress = proxyOptions.getAddress();
        this.username = proxyOptions.getUsername();
        this.password = proxyOptions.getPassword();
        this.nonProxyHosts = proxyOptions.getNonProxyHosts();
        this.nonProxyHostsPattern = this.nonProxyHosts == null ? null : Pattern.compile(this.nonProxyHosts, 2);
    }

    @Override
    public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
        return (connectionObserver, channel) -> {
            if (this.shouldApplyProxy(bootstrap.config().remoteAddress())) {
                channel.pipeline().addFirst("reactor.left.proxyHandler", (ChannelHandler)new HttpProxyHandler(this.proxyAddress, this.challengeHandler, this.proxyChallengeHolderReference)).addLast("azure.proxy.exceptionHandler", (ChannelHandler)new HttpProxyExceptionHandler());
            }
        };
    }

    private boolean shouldApplyProxy(SocketAddress socketAddress) {
        if (this.nonProxyHostsPattern == null) {
            return true;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return true;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !this.nonProxyHostsPattern.matcher(inetSocketAddress.getHostString()).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeferredHttpProxyProvider)) {
            return false;
        }
        DeferredHttpProxyProvider other = (DeferredHttpProxyProvider)o;
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.proxyAddress, other.proxyAddress) && Objects.equals(this.nonProxyHosts, other.nonProxyHosts);
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.password, this.proxyAddress, this.nonProxyHosts);
    }
}

