/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosContainerProactiveInitConfigBuilder;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.GlobalThroughputControlConfig;
import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.ChangeFeedOperationState;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyHelper;
import com.azure.cosmos.implementation.QueryFeedOperationState;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.WriteRetryPolicy;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.batch.BatchExecutor;
import com.azure.cosmos.implementation.batch.BulkExecutor;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.throughputControl.config.GlobalThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.config.LocalThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupFactory;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosBulkOperationResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private static final Logger logger = LoggerFactory.getLogger(CosmosAsyncContainer.class);
    private static final ImplementationBridgeHelpers.CosmosAsyncClientHelper.CosmosAsyncClientAccessor clientAccessor = ImplementationBridgeHelpers.CosmosAsyncClientHelper.getCosmosAsyncClientAccessor();
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosItemRequestOptionsHelper.CosmosItemRequestOptionsAccessor itemOptionsAccessor = ImplementationBridgeHelpers.CosmosItemRequestOptionsHelper.getCosmosItemRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private static final ImplementationBridgeHelpers.CosmosItemResponseHelper.CosmosItemResponseBuilderAccessor itemResponseAccessor = ImplementationBridgeHelpers.CosmosItemResponseHelper.getCosmosItemResponseBuilderAccessor();
    private final CosmosAsyncDatabase database;
    private final String id;
    private final String link;
    private final String replaceContainerSpanName;
    private final String deleteContainerSpanName;
    private final String replaceThroughputSpanName;
    private final String readThroughputSpanName;
    private final String readContainerSpanName;
    private final String readItemSpanName;
    private final String upsertItemSpanName;
    private final String deleteItemSpanName;
    private final String deleteAllItemsByPartitionKeySpanName;
    private final String replaceItemSpanName;
    private final String patchItemSpanName;
    private final String createItemSpanName;
    private final String readAllItemsSpanName;
    private final String readManyItemsSpanName;
    private final String readAllItemsOfLogicalPartitionSpanName;
    private final String queryItemsSpanName;
    private final String queryChangeFeedSpanName;
    private final String readAllConflictsSpanName;
    private final String queryConflictsSpanName;
    private final String batchSpanName;
    private final AtomicBoolean isInitialized;
    private CosmosAsyncScripts scripts;
    private IFaultInjectorProvider faultInjectorProvider;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
        this.replaceContainerSpanName = "replaceContainer." + this.id;
        this.deleteContainerSpanName = "deleteContainer." + this.id;
        this.replaceThroughputSpanName = "replaceThroughput." + this.id;
        this.readThroughputSpanName = "readThroughput." + this.id;
        this.readContainerSpanName = "readContainer." + this.id;
        this.readItemSpanName = "readItem." + this.id;
        this.upsertItemSpanName = "upsertItem." + this.id;
        this.deleteItemSpanName = "deleteItem." + this.id;
        this.deleteAllItemsByPartitionKeySpanName = "deleteAllItemsByPartitionKey." + this.id;
        this.replaceItemSpanName = "replaceItem." + this.id;
        this.patchItemSpanName = "patchItem." + this.id;
        this.createItemSpanName = "createItem." + this.id;
        this.readAllItemsSpanName = "readAllItems." + this.id;
        this.readManyItemsSpanName = "readManyItems." + this.id;
        this.readAllItemsOfLogicalPartitionSpanName = "readAllItemsOfLogicalPartition." + this.id;
        this.queryItemsSpanName = "queryItems." + this.id;
        this.queryChangeFeedSpanName = "queryChangeFeed." + this.id;
        this.readAllConflictsSpanName = "readAllConflicts." + this.id;
        this.queryConflictsSpanName = "queryConflicts." + this.id;
        this.batchSpanName = "transactionalBatch." + this.id;
        this.isInitialized = new AtomicBoolean(false);
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.read(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> delete(CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties) {
        return this.replace(containerProperties, null);
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.replaceInternal(containerProperties, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        return this.createItem(item, options);
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.createItemInternal(item, requestOptions, (Context)context));
    }

    private static void mergeDiagnostics(CosmosException originalCosmosException, CosmosException readCosmosError) {
        Preconditions.checkNotNull(originalCosmosException, "Argument 'originalCosmosException' must not be null.");
        Preconditions.checkNotNull(readCosmosError, "Argument 'readCosmosError' must not be null.");
        CosmosDiagnostics readDiagnostics = readCosmosError.getDiagnostics();
        if (readDiagnostics != null && readDiagnostics.getClientSideRequestStatisticsRaw() != null) {
            CosmosDiagnostics originalDiagnostics = originalCosmosException.getDiagnostics();
            if (originalDiagnostics == null || originalDiagnostics.getClientSideRequestStatisticsRaw() == null) {
                originalCosmosException.setDiagnostics(readDiagnostics);
            } else {
                originalDiagnostics.clientSideRequestStatistics().recordContributingPointOperation(readDiagnostics.getClientSideRequestStatisticsRaw());
            }
        }
    }

    private static void mergeDiagnostics(ResourceResponse<Document> readResponse, CosmosException originalCosmosException) {
        CosmosDiagnostics responseDiagnostics = readResponse.getDiagnostics();
        if (responseDiagnostics != null && responseDiagnostics.getClientSideRequestStatisticsRaw() != null) {
            CosmosDiagnostics errorDiagnostics = originalCosmosException.getDiagnostics();
            if (errorDiagnostics != null) {
                responseDiagnostics.clientSideRequestStatistics().recordContributingPointOperation(errorDiagnostics.getClientSideRequestStatisticsRaw());
            }
            readResponse.addRequestCharge(originalCosmosException.getRequestCharge());
        }
    }

    private <T> Mono<CosmosItemResponse<T>> replaceItemWithTrackingId(Class<T> itemType, String itemId, Document doc, RequestOptions requestOptions, String trackingId) {
        Preconditions.checkNotNull(trackingId, "Argument 'trackingId' must not be null.");
        return this.replaceItemInternalCore(itemType, itemId, doc, requestOptions, trackingId).onErrorResume(throwable -> {
            Throwable error;
            Throwable throwable2 = error = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            if (!(error instanceof CosmosException)) {
                Exception nonCosmosException = error instanceof Exception ? (Exception)error : new RuntimeException(error);
                return Mono.error((Throwable)nonCosmosException);
            }
            assert (error instanceof CosmosException);
            CosmosException cosmosException = (CosmosException)((Object)((Object)error));
            if (cosmosException.getStatusCode() != 412) {
                return Mono.error((Throwable)((Object)cosmosException));
            }
            Mono readMono = this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> {
                CosmosAsyncContainer.mergeDiagnostics(response, cosmosException);
                return ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer());
            }).single();
            return readMono.onErrorMap(readThrowable -> {
                if (readThrowable instanceof CosmosException) {
                    CosmosAsyncContainer.mergeDiagnostics(cosmosException, (CosmosException)((Object)((Object)((Object)readThrowable))));
                }
                return cosmosException;
            }).flatMap(readResponse -> {
                if (readResponse.getStatusCode() == 200 && itemResponseAccessor.hasTrackingId((CosmosItemResponse<?>)readResponse, trackingId)) {
                    return Mono.just(itemResponseAccessor.withRemappedStatusCode(readResponse, 200, cosmosException.getRequestCharge(), this.isContentResponseOnWriteEffectivelyEnabled(requestOptions)));
                }
                return Mono.error((Throwable)((Object)cosmosException));
            });
        });
    }

    private <T> Mono<CosmosItemResponse<T>> createItemWithTrackingId(T item, RequestOptions options, String trackingId) {
        Preconditions.checkNotNull(trackingId, "Argument 'trackingId' must not be null.");
        return this.createItemInternalCore(item, options, trackingId).onErrorResume(throwable -> {
            Throwable error;
            Throwable throwable2 = error = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            if (!(error instanceof CosmosException)) {
                Exception nonCosmosException = error instanceof Exception ? (Exception)error : new RuntimeException(error);
                return Mono.error((Throwable)nonCosmosException);
            }
            assert (error instanceof CosmosException);
            CosmosException cosmosException = (CosmosException)((Object)((Object)error));
            if (cosmosException.getStatusCode() != 409) {
                return Mono.error((Throwable)((Object)cosmosException));
            }
            InternalObjectNode internalObjectNode = InternalObjectNode.fromObjectToInternalObjectNode(item);
            String itemId = internalObjectNode.getId();
            RequestOptions readRequestOptions = new RequestOptions(options);
            readRequestOptions.setConsistencyLevel(null);
            Class<?> itemType = item.getClass();
            AsyncDocumentClient clientWrapper = this.getDatabase().getDocClientWrapper();
            Mono readMono = clientWrapper.getCollectionCache().resolveByNameAsync(null, this.getLinkWithoutTrailingSlash(), null).flatMap(collection -> {
                if (collection == null) {
                    throw new IllegalStateException("Collection cannot be null");
                }
                PartitionKeyDefinition pkDef = collection.getPartitionKey();
                PartitionKeyInternal partitionKeyInternal = PartitionKeyHelper.extractPartitionKeyValueFromDocument(internalObjectNode, pkDef);
                PartitionKey partitionKey = ImplementationBridgeHelpers.PartitionKeyHelper.getPartitionKeyAccessor().toPartitionKey(partitionKeyInternal);
                readRequestOptions.setPartitionKey(partitionKey);
                return clientWrapper.readDocument(this.getItemLink(itemId), readRequestOptions).map(response -> {
                    CosmosAsyncContainer.mergeDiagnostics(response, cosmosException);
                    return ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer());
                }).single();
            });
            return readMono.onErrorMap(readThrowable -> {
                if (readThrowable instanceof CosmosException) {
                    CosmosAsyncContainer.mergeDiagnostics(cosmosException, (CosmosException)((Object)((Object)((Object)readThrowable))));
                }
                return cosmosException;
            }).flatMap(readResponse -> {
                if (readResponse.getStatusCode() == 200 && itemResponseAccessor.hasTrackingId((CosmosItemResponse<?>)readResponse, trackingId)) {
                    return Mono.just(itemResponseAccessor.withRemappedStatusCode(readResponse, 201, cosmosException.getRequestCharge(), this.isContentResponseOnWriteEffectivelyEnabled(options)));
                }
                return Mono.error((Throwable)((Object)cosmosException));
            });
        });
    }

    private boolean isContentResponseOnWriteEffectivelyEnabled(RequestOptions options) {
        Boolean requestOptionsContentResponseEnabled = null;
        if (options != null) {
            requestOptionsContentResponseEnabled = options.isContentResponseOnWriteEnabled();
        }
        return clientAccessor.isEffectiveContentResponseOnWriteEnabled(this.database.getClient(), requestOptionsContentResponseEnabled);
    }

    private <T> Mono<CosmosItemResponse<T>> createItemInternal(T item, CosmosItemRequestOptions options, Context context) {
        Mono<CosmosItemResponse<T>> responseMono;
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        WriteRetryPolicy nonIdempotentWriteRetryPolicy = itemOptionsAccessor.calculateAndGetEffectiveNonIdempotentRetriesEnabled(options, this.database.getClient().getNonIdempotentWriteRetryPolicy(), true);
        String trackingId = null;
        CosmosItemRequestOptions effectiveOptions = this.getEffectiveOptions(nonIdempotentWriteRetryPolicy, options);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(effectiveOptions);
        if (nonIdempotentWriteRetryPolicy.isEnabled() && nonIdempotentWriteRetryPolicy.useTrackingIdProperty()) {
            trackingId = UUID.randomUUID().toString();
            responseMono = this.createItemWithTrackingId(item, requestOptions, trackingId);
        } else {
            responseMono = this.createItemInternalCore(item, requestOptions, null);
        }
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.createItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(effectiveOptions), OperationType.Create, ResourceType.Document, requestOptions, trackingId);
    }

    private <T> Mono<CosmosItemResponse<T>> createItemInternalCore(T item, RequestOptions requestOptions, String trackingId) {
        Class<?> itemType = item.getClass();
        requestOptions.setTrackingId(trackingId);
        return this.database.getDocClientWrapper().createDocument(this.getLink(), item, requestOptions, true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions requestOptions = options == null ? new CosmosItemRequestOptions() : options;
        return FluxUtil.withContext(context -> this.upsertItemInternal(item, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions requestOptions = options == null ? new CosmosItemRequestOptions() : options;
        ModelBridgeInternal.setPartitionKey(requestOptions, partitionKey);
        return FluxUtil.withContext(context -> this.upsertItemInternal(item, requestOptions, (Context)context));
    }

    <T> CosmosPagedFlux<T> readAllItems(Class<T> classType) {
        return this.readAllItems(new CosmosQueryRequestOptions(), classType);
    }

    <T> CosmosPagedFlux<T> readAllItems(CosmosQueryRequestOptions options, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            CosmosAsyncClient client = this.getDatabase().getClient();
            CosmosQueryRequestOptions requestOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, this.readAllItemsSpanName, this.database.getId(), this.getId(), ResourceType.Document, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(requestOptions, this.readAllItemsSpanName), requestOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), state, classType).map(response -> this.prepareFeedResponse((FeedResponse)response, false));
        });
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, Class<T> classType) {
        return this.queryItemsInternal(new SqlQuerySpec(query), new CosmosQueryRequestOptions(), classType);
    }

    @Deprecated
    public Mono<Void> openConnectionsAndInitCaches() {
        if (this.isInitialized.compareAndSet(false, true)) {
            CosmosContainerIdentity cosmosContainerIdentity = new CosmosContainerIdentity(this.database.getId(), this.id);
            CosmosContainerProactiveInitConfig proactiveContainerInitConfig = new CosmosContainerProactiveInitConfigBuilder(Collections.singletonList(cosmosContainerIdentity)).setProactiveConnectionRegionsCount(1).setMinConnectionPoolSizePerEndpointForContainer(cosmosContainerIdentity, Configs.getMinConnectionPoolSizePerEndpoint()).build();
            return FluxUtil.withContext(context -> this.openConnectionsAndInitCachesInternal(proactiveContainerInitConfig).collectList().flatMap(openResult -> {
                logger.debug("OpenConnectionsAndInitCaches: {}", openResult);
                return Mono.empty();
            }));
        }
        logger.warn("OpenConnectionsAndInitCaches is already called once on Container {}, no operation will take place in this call", (Object)this.getId());
        return Mono.empty();
    }

    @Deprecated
    public Mono<Void> openConnectionsAndInitCaches(int numProactiveConnectionRegions) {
        List<String> preferredRegions = clientAccessor.getPreferredRegions(this.database.getClient());
        boolean endpointDiscoveryEnabled = clientAccessor.isEndpointDiscoveryEnabled(this.database.getClient());
        Preconditions.checkArgument(numProactiveConnectionRegions > 0, "no. of proactive connection regions should be greater than 0");
        if (numProactiveConnectionRegions > 1) {
            Preconditions.checkArgument(endpointDiscoveryEnabled, "endpoint discovery should be enabled when no. of proactive regions is greater than 1");
            Preconditions.checkArgument(preferredRegions != null && preferredRegions.size() >= numProactiveConnectionRegions, "no. of proactive connection regions should be lesser than the no. of preferred regions.");
        }
        if (this.isInitialized.compareAndSet(false, true)) {
            CosmosContainerIdentity cosmosContainerIdentity = new CosmosContainerIdentity(this.database.getId(), this.id);
            CosmosContainerProactiveInitConfig proactiveContainerInitConfig = new CosmosContainerProactiveInitConfigBuilder(Arrays.asList(cosmosContainerIdentity)).setProactiveConnectionRegionsCount(numProactiveConnectionRegions).build();
            return FluxUtil.withContext(context -> this.openConnectionsAndInitCachesInternal(proactiveContainerInitConfig).collectList().flatMap(openResult -> {
                logger.debug("OpenConnectionsAndInitCaches: {}", openResult);
                return Mono.empty();
            }));
        }
        logger.warn("OpenConnectionsAndInitCaches is already called once on Container {}, no operation will take place in this call", (Object)this.getId());
        return Mono.empty();
    }

    private Flux<Void> openConnectionsAndInitCachesInternal(CosmosContainerProactiveInitConfig proactiveContainerInitConfig) {
        return this.database.getDocClientWrapper().submitOpenConnectionTasksAndInitCaches(proactiveContainerInitConfig).doOnSubscribe(subscription -> this.database.getDocClientWrapper().recordOpenConnectionsAndInitCachesStarted(proactiveContainerInitConfig.getCosmosContainerIdentities())).doOnTerminate(() -> this.database.getDocClientWrapper().recordOpenConnectionsAndInitCachesCompleted(proactiveContainerInitConfig.getCosmosContainerIdentities()));
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryItemsInternal(new SqlQuerySpec(query), options, classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, Class<T> classType) {
        return this.queryItemsInternal(querySpec, new CosmosQueryRequestOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryItemsInternal(querySpec, options, classType);
    }

    <T> CosmosPagedFlux<T> queryItemsInternal(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        if (cosmosQueryRequestOptions != null && cosmosQueryRequestOptions.getPartitionKey() != null && cosmosQueryRequestOptions.getFeedRange() != null) {
            throw new IllegalArgumentException("Setting partitionKey and feedRange at the same time is not allowed");
        }
        return UtilBridgeInternal.createCosmosPagedFlux(this.queryItemsInternalFunc(sqlQuerySpec, cosmosQueryRequestOptions, classType));
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFunc(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        CosmosAsyncClient client = this.getDatabase().getClient();
        CosmosQueryRequestOptions options = cosmosQueryRequestOptions != null ? cosmosQueryRequestOptions : new CosmosQueryRequestOptions();
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            String spanName = this.queryItemsSpanName;
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.database.getId(), this.getId(), ResourceType.Document, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(options, spanName), options, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), sqlQuerySpec, state, classType).map(response -> this.prepareFeedResponse((FeedResponse)response, false));
        };
        return pagedFluxOptionsFluxFunction;
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFunc(Mono<SqlQuerySpec> sqlQuerySpecMono, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            CosmosAsyncClient client = this.getDatabase().getClient();
            CosmosQueryRequestOptions options = cosmosQueryRequestOptions != null ? cosmosQueryRequestOptions : new CosmosQueryRequestOptions();
            String spanName = this.queryItemsSpanName;
            QueryFeedOperationState state = new QueryFeedOperationState(client, spanName, this.database.getId(), this.getId(), ResourceType.Document, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(options, spanName), options, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return sqlQuerySpecMono.flux().flatMap(sqlQuerySpec -> this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), (SqlQuerySpec)sqlQuerySpec, state, classType)).map(response -> this.prepareFeedResponse((FeedResponse)response, false));
        };
        return pagedFluxOptionsFluxFunction;
    }

    public <T> CosmosPagedFlux<T> queryChangeFeed(CosmosChangeFeedRequestOptions options, Class<T> classType) {
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        Preconditions.checkNotNull(classType, "Argument 'classType' must not be null.");
        return this.queryChangeFeedInternal(options, classType);
    }

    <T> CosmosPagedFlux<T> queryChangeFeedInternal(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(this.queryChangeFeedInternalFunc(cosmosChangeFeedRequestOptions, classType));
    }

    String getLinkWithoutTrailingSlash() {
        if (this.link.startsWith("/")) {
            return this.link.substring(1);
        }
        return this.link;
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
        Preconditions.checkNotNull(cosmosChangeFeedRequestOptions, "Argument 'cosmosChangeFeedRequestOptions' must not be null.");
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            Preconditions.checkNotNull(pagedFluxOptions, "Argument 'pagedFluxOptions' must not be null.");
            CosmosAsyncClient client = this.getDatabase().getClient();
            String spanName = this.queryChangeFeedSpanName;
            ChangeFeedOperationState state = new ChangeFeedOperationState(client, spanName, this.database.getId(), this.getId(), ResourceType.Document, OperationType.ReadFeed, spanName, cosmosChangeFeedRequestOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
            return clientWrapper.getCollectionCache().resolveByNameAsync(null, this.getLinkWithoutTrailingSlash(), null).flatMapMany(collection -> {
                if (collection == null) {
                    throw new IllegalStateException("Collection cannot be null");
                }
                return clientWrapper.queryDocumentChangeFeedFromPagedFlux((DocumentCollection)collection, state, classType).map(response -> this.prepareFeedResponse((FeedResponse)response, true));
            });
        };
        return pagedFluxOptionsFluxFunction;
    }

    private <T> FeedResponse<T> prepareFeedResponse(FeedResponse<T> response, boolean isChangeFeed) {
        boolean useEtagAsContinuation = isChangeFeed;
        boolean isNoChangesResponse = isChangeFeed ? ModelBridgeInternal.getNoChangesFromFeedResponse(response) : false;
        return BridgeInternal.createFeedResponseWithQueryMetrics(response.getResults(), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), useEtagAsContinuation, isNoChangesResponse, response.getCosmosDiagnostics());
    }

    public Mono<CosmosBatchResponse> executeCosmosBatch(CosmosBatch cosmosBatch) {
        return this.executeCosmosBatch(cosmosBatch, new CosmosBatchRequestOptions());
    }

    public Mono<CosmosBatchResponse> executeCosmosBatch(CosmosBatch cosmosBatch, CosmosBatchRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new CosmosBatchRequestOptions();
        }
        CosmosBatchRequestOptions cosmosBatchRequestOptions = requestOptions;
        return FluxUtil.withContext(context -> {
            BatchExecutor executor = new BatchExecutor(this, cosmosBatch, cosmosBatchRequestOptions);
            Mono<CosmosBatchResponse> responseMono = executor.executeAsync();
            RequestOptions requestOptionsInternal = ModelBridgeInternal.toRequestOptions(cosmosBatchRequestOptions);
            CosmosAsyncClient client = this.database.getClient();
            return client.getDiagnosticsProvider().traceEnabledBatchResponsePublisher(responseMono, (Context)context, this.batchSpanName, this.database.getId(), this.id, client, ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.getCosmosBatchRequestOptionsAccessor().getConsistencyLevel(cosmosBatchRequestOptions), OperationType.Batch, ResourceType.Document, requestOptionsInternal);
        });
    }

    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> executeBulkOperations(Flux<CosmosItemOperation> operations) {
        return this.executeBulkOperations(operations, new CosmosBulkExecutionOptions());
    }

    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> executeBulkOperations(Flux<CosmosItemOperation> operations, CosmosBulkExecutionOptions bulkOptions) {
        if (bulkOptions == null) {
            bulkOptions = new CosmosBulkExecutionOptions();
        }
        CosmosBulkExecutionOptions cosmosBulkExecutionOptions = bulkOptions;
        return Flux.deferContextual(context -> {
            BulkExecutor executor = new BulkExecutor(this, operations, cosmosBulkExecutionOptions);
            return executor.execute().publishOn(CosmosSchedulers.BULK_EXECUTOR_BOUNDED_ELASTIC);
        });
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.readItem(itemId, partitionKey, ModelBridgeInternal.createCosmosItemRequestOptions(partitionKey), itemType);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.readItemInternal(itemId, requestOptions, itemType, (Context)context));
    }

    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, Class<T> classType) {
        return this.readMany(itemIdentityList, new CosmosQueryRequestOptions(), classType);
    }

    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, String sessionToken, Class<T> classType) {
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        if (!StringUtils.isNotEmpty(sessionToken)) {
            options = options.setSessionToken(sessionToken);
        }
        options.setMaxDegreeOfParallelism(-1);
        return this.readMany(itemIdentityList, options, classType);
    }

    <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, CosmosQueryRequestOptions requestOptions, Class<T> classType) {
        requestOptions.setMaxDegreeOfParallelism(-1);
        CosmosAsyncClient client = this.getDatabase().getClient();
        CosmosPagedFluxOptions fluxOptions = new CosmosPagedFluxOptions();
        fluxOptions.setMaxItemCount(itemIdentityList != null ? itemIdentityList.size() : 0);
        QueryFeedOperationState state = new QueryFeedOperationState(client, this.readAllItemsSpanName, this.database.getId(), this.getId(), ResourceType.Document, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(requestOptions, this.readManyItemsSpanName), requestOptions, fluxOptions);
        return CosmosBridgeInternal.getAsyncDocumentClient(this.getDatabase()).readMany(itemIdentityList, BridgeInternal.getLink(this), state, classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(PartitionKey partitionKey, Class<T> classType) {
        CosmosQueryRequestOptions queryRequestOptions = new CosmosQueryRequestOptions();
        queryRequestOptions.setPartitionKey(partitionKey);
        return this.readAllItems(partitionKey, queryRequestOptions, classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(PartitionKey partitionKey, CosmosQueryRequestOptions options, Class<T> classType) {
        CosmosAsyncClient client = this.getDatabase().getClient();
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        requestOptions.setPartitionKey(partitionKey);
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            QueryFeedOperationState state = new QueryFeedOperationState(client, this.readAllItemsOfLogicalPartitionSpanName, this.database.getId(), this.getId(), ResourceType.Document, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(requestOptions, this.readAllItemsOfLogicalPartitionSpanName), requestOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.getDatabase().getDocClientWrapper().readAllDocuments(this.getLink(), partitionKey, state, classType).map(response -> this.prepareFeedResponse((FeedResponse)response, false));
        });
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Document doc = InternalObjectNode.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        Class<?> itemType = item.getClass();
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.replaceItemInternal(itemType, itemId, doc, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, Class<T> itemType) {
        return this.patchItem(itemId, partitionKey, cosmosPatchOperations, new CosmosPatchItemRequestOptions(), itemType);
    }

    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        Preconditions.checkNotNull(itemId, "expected non-null itemId");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey for patchItem");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (options == null) {
            options = new CosmosPatchItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        CosmosPatchItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.patchItemInternal(itemId, cosmosPatchOperations, requestOptions, (Context)context, itemType));
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        CosmosItemRequestOptions finalOptions = options;
        return FluxUtil.withContext(context -> this.deleteItemInternal(itemId, null, finalOptions, (Context)context));
    }

    public Mono<CosmosItemResponse<Object>> deleteAllItemsByPartitionKey(PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.deleteAllItemsByPartitionKeyInternal(partitionKey, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<Object>> deleteItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        CosmosItemRequestOptions finalOptions = options;
        InternalObjectNode internalObjectNode = InternalObjectNode.fromObjectToInternalObjectNode(item);
        return FluxUtil.withContext(context -> this.deleteItemInternal(internalObjectNode.getId(), internalObjectNode, finalOptions, (Context)context));
    }

    private String getItemLink(String itemId) {
        String builder = this.getLink() + "/" + "docs" + "/" + itemId;
        return builder;
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public CosmosPagedFlux<CosmosConflictProperties> readAllConflicts(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            CosmosAsyncClient client = this.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            QueryFeedOperationState state = new QueryFeedOperationState(client, this.readAllConflictsSpanName, this.database.getId(), this.getId(), ResourceType.Conflict, OperationType.ReadFeed, queryOptionsAccessor.getQueryNameOrDefault(nonNullOptions, this.readAllConflictsSpanName), nonNullOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.database.getDocClientWrapper().readConflicts(this.getLink(), state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query) {
        return this.queryConflicts(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query, CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            CosmosAsyncClient client = this.getDatabase().getClient();
            String operationId = queryOptionsAccessor.getQueryNameOrDefault(requestOptions, this.queryConflictsSpanName);
            QueryFeedOperationState state = new QueryFeedOperationState(client, this.queryConflictsSpanName, this.database.getId(), this.getId(), ResourceType.Conflict, OperationType.Query, queryOptionsAccessor.getQueryNameOrDefault(requestOptions, this.queryConflictsSpanName), requestOptions, (CosmosPagedFluxOptions)pagedFluxOptions);
            pagedFluxOptions.setFeedOperationState(state);
            return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, state).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return FluxUtil.withContext(context -> this.replaceThroughputInternal(throughputProperties, (Context)context));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return FluxUtil.withContext(context -> this.readThroughputInternal((Context)context));
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String getURIPathSegment() {
        return "colls";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.link;
    }

    private Mono<CosmosItemResponse<Object>> deleteItemInternal(String itemId, InternalObjectNode internalObjectNode, CosmosItemRequestOptions options, Context context) {
        WriteRetryPolicy nonIdempotentWriteRetryPolicy = itemOptionsAccessor.calculateAndGetEffectiveNonIdempotentRetriesEnabled(options, this.database.getClient().getNonIdempotentWriteRetryPolicy(), true);
        CosmosItemRequestOptions effectiveOptions = this.getEffectiveOptions(nonIdempotentWriteRetryPolicy, options);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(effectiveOptions);
        return this.deleteItemInternalCore(itemId, internalObjectNode, requestOptions, context);
    }

    private Mono<CosmosItemResponse<Object>> deleteItemInternalCore(String itemId, InternalObjectNode internalObjectNode, RequestOptions requestOptions, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().deleteDocument(this.getItemLink(itemId), internalObjectNode, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.deleteItemSpanName, this.getId(), this.database.getId(), client, requestOptions.getConsistencyLevel(), OperationType.Delete, ResourceType.Document, requestOptions, null);
    }

    private Mono<CosmosItemResponse<Object>> deleteAllItemsByPartitionKeyInternal(PartitionKey partitionKey, RequestOptions requestOptions, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().deleteAllDocumentsByPartitionKey(this.getLink(), partitionKey, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.deleteAllItemsByPartitionKeySpanName, this.getId(), this.database.getId(), client, requestOptions.getConsistencyLevel(), OperationType.Delete, ResourceType.PartitionKey, requestOptions, null);
    }

    private <T> Mono<CosmosItemResponse<T>> replaceItemInternalCore(Class<T> itemType, String itemId, Document doc, RequestOptions requestOptions, String trackingId) {
        requestOptions.setTrackingId(trackingId);
        return this.getDatabase().getDocClientWrapper().replaceDocument(this.getItemLink(itemId), doc, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
    }

    private CosmosItemRequestOptions getEffectiveOptions(WriteRetryPolicy nonIdempotentWriteRetryPolicy, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions effectiveOptions = itemOptionsAccessor.clone(options);
        effectiveOptions.setConsistencyLevel(null);
        if (nonIdempotentWriteRetryPolicy.isEnabled()) {
            itemOptionsAccessor.setNonIdempotentWriteRetryPolicy(effectiveOptions, true, nonIdempotentWriteRetryPolicy.useTrackingIdProperty());
        } else {
            itemOptionsAccessor.setNonIdempotentWriteRetryPolicy(effectiveOptions, false, false);
        }
        return effectiveOptions;
    }

    private <T> Mono<CosmosItemResponse<T>> replaceItemInternal(Class<T> itemType, String itemId, Document doc, CosmosItemRequestOptions options, Context context) {
        Mono<CosmosItemResponse<T>> responseMono;
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        WriteRetryPolicy nonIdempotentWriteRetryPolicy = itemOptionsAccessor.calculateAndGetEffectiveNonIdempotentRetriesEnabled(options, this.database.getClient().getNonIdempotentWriteRetryPolicy(), true);
        CosmosItemRequestOptions effectiveOptions = this.getEffectiveOptions(nonIdempotentWriteRetryPolicy, options);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(effectiveOptions);
        String trackingId = null;
        if (nonIdempotentWriteRetryPolicy.isEnabled() && nonIdempotentWriteRetryPolicy.useTrackingIdProperty()) {
            trackingId = UUID.randomUUID().toString();
            responseMono = this.replaceItemWithTrackingId(itemType, itemId, doc, requestOptions, trackingId);
        } else {
            responseMono = this.replaceItemInternalCore(itemType, itemId, doc, requestOptions, null);
        }
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.replaceItemSpanName, this.getId(), this.database.getId(), client, ModelBridgeInternal.getConsistencyLevel(effectiveOptions), OperationType.Replace, ResourceType.Document, requestOptions, trackingId);
    }

    private <T> Mono<CosmosItemResponse<T>> patchItemInternal(String itemId, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Context context, Class<T> itemType) {
        WriteRetryPolicy nonIdempotentWriteRetryPolicy = itemOptionsAccessor.calculateAndGetEffectiveNonIdempotentRetriesEnabled(options, this.database.getClient().getNonIdempotentWriteRetryPolicy(), false);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        if (nonIdempotentWriteRetryPolicy.isEnabled()) {
            requestOptions.setNonIdempotentWriteRetriesEnabled(true);
        }
        Mono responseMono = this.getDatabase().getDocClientWrapper().patchDocument(this.getItemLink(itemId), cosmosPatchOperations, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer()));
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.patchItemSpanName, this.getId(), this.database.getId(), client, ModelBridgeInternal.getConsistencyLevel(options), OperationType.Patch, ResourceType.Document, requestOptions, null);
    }

    private <T> Mono<CosmosItemResponse<T>> upsertItemInternal(T item, CosmosItemRequestOptions options, Context context) {
        Class<?> itemType = item.getClass();
        WriteRetryPolicy nonIdempotentWriteRetryPolicy = itemOptionsAccessor.calculateAndGetEffectiveNonIdempotentRetriesEnabled(options, this.database.getClient().getNonIdempotentWriteRetryPolicy(), true);
        CosmosItemRequestOptions effectiveOptions = this.getEffectiveOptions(nonIdempotentWriteRetryPolicy, options);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(effectiveOptions);
        Mono responseMono = this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), item, requestOptions, true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.upsertItemSpanName, this.getId(), this.database.getId(), client, ModelBridgeInternal.getConsistencyLevel(effectiveOptions), OperationType.Upsert, ResourceType.Document, requestOptions, null);
    }

    private <T> Mono<CosmosItemResponse<T>> readItemInternal(String itemId, RequestOptions requestOptions, Class<T> itemType, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.readItemSpanName, this.getId(), this.database.getId(), client, requestOptions.getConsistencyLevel(), OperationType.Read, ResourceType.Document, requestOptions, null);
    }

    Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options, Context context) {
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        Mono responseMono = this.database.getDocClientWrapper().readCollection(this.getLink(), requestOptions).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.readContainerSpanName, this.database.getId(), this.id, client, null, OperationType.Read, ResourceType.DocumentCollection, requestOptions);
    }

    private Mono<CosmosContainerResponse> deleteInternal(CosmosContainerRequestOptions options, Context context) {
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        Mono responseMono = this.database.getDocClientWrapper().deleteCollection(this.getLink(), requestOptions).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.deleteContainerSpanName, this.database.getId(), this.id, client, null, OperationType.Replace, ResourceType.DocumentCollection, requestOptions);
    }

    private Mono<CosmosContainerResponse> replaceInternal(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().replaceCollection(ModelBridgeInternal.getV2Collection(containerProperties), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.replaceContainerSpanName, this.database.getId(), containerProperties.getId(), client, null, OperationType.Replace, ResourceType.DocumentCollection, requestOptions);
    }

    private Mono<ThroughputResponse> readThroughputInternal(Context context) {
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        Mono<ThroughputResponse> responseMono = this.readThroughputInternal(this.read(options, nestedContext));
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.readThroughputSpanName, this.database.getId(), this.id, client, null, OperationType.Read, ResourceType.Offer, requestOptions);
    }

    private Mono<ThroughputResponse> readThroughputInternal(Mono<CosmosContainerResponse> responseMono) {
        QueryFeedOperationState state = new QueryFeedOperationState(this.database.getClient(), "readThroughputInternal", this.database.getId(), this.getId(), ResourceType.Offer, OperationType.Query, null, new CosmosQueryRequestOptions(), new CosmosPagedFluxOptions());
        return responseMono.flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), state).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(ThroughputProperties throughputProperties, Context context) {
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        Mono<ThroughputResponse> responseMono = this.replaceThroughputInternal(this.read(options, nestedContext), throughputProperties);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.replaceThroughputSpanName, this.database.getId(), this.id, client, null, OperationType.Replace, ResourceType.Offer, requestOptions);
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(Mono<CosmosContainerResponse> responseMono, ThroughputProperties throughputProperties) {
        QueryFeedOperationState state = new QueryFeedOperationState(this.database.getClient(), "replaceThroughputInternal", this.database.getId(), this.getId(), ResourceType.Offer, OperationType.Query, null, new CosmosQueryRequestOptions(), new CosmosPagedFluxOptions());
        return responseMono.flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), state).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.database.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    ItemDeserializer getItemDeserializer() {
        return this.getDatabase().getDocClientWrapper().getItemDeserializer();
    }

    public Mono<List<FeedRange>> getFeedRanges() {
        return this.getDatabase().getDocClientWrapper().getFeedRanges(this.getLink());
    }

    Mono<List<FeedRangeEpkImpl>> trySplitFeedRange(FeedRange feedRange, int targetedCountAfterSplit) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
        Mono getCollectionObservable = clientWrapper.getCollectionCache().resolveByNameAsync(null, this.getLinkWithoutTrailingSlash(), null).map(collection -> Utils.ValueHolder.initialize(collection));
        return FeedRangeInternal.convert(feedRange).trySplit(clientWrapper.getPartitionKeyRangeCache(), null, (Mono<Utils.ValueHolder<DocumentCollection>>)getCollectionObservable, targetedCountAfterSplit);
    }

    Mono<Range<String>> getNormalizedEffectiveRange(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
        Mono getCollectionObservable = clientWrapper.getCollectionCache().resolveByNameAsync(null, this.getLinkWithoutTrailingSlash(), null).map(collection -> Utils.ValueHolder.initialize(collection));
        return FeedRangeInternal.convert(feedRange).getNormalizedEffectiveRange(clientWrapper.getPartitionKeyRangeCache(), null, (Mono<Utils.ValueHolder<DocumentCollection>>)getCollectionObservable);
    }

    public void enableLocalThroughputControlGroup(ThroughputControlGroupConfig groupConfig) {
        this.enableLocalThroughputControlGroup(groupConfig, null);
    }

    void enableLocalThroughputControlGroup(ThroughputControlGroupConfig groupConfig, Mono<Integer> throughputQueryMono) {
        LocalThroughputControlGroup localControlGroup = ThroughputControlGroupFactory.createThroughputLocalControlGroup(groupConfig, this);
        this.database.getClient().enableThroughputControlGroup(localControlGroup, throughputQueryMono);
    }

    public void enableGlobalThroughputControlGroup(ThroughputControlGroupConfig groupConfig, GlobalThroughputControlConfig globalControlConfig) {
        this.enableGlobalThroughputControlGroup(groupConfig, globalControlConfig, null);
    }

    void enableGlobalThroughputControlGroup(ThroughputControlGroupConfig groupConfig, GlobalThroughputControlConfig globalControlConfig, Mono<Integer> throughputQueryMono) {
        GlobalThroughputControlGroup globalControlGroup = ThroughputControlGroupFactory.createThroughputGlobalControlGroup(groupConfig, globalControlConfig, this);
        this.database.getClient().enableThroughputControlGroup(globalControlGroup, throughputQueryMono);
    }

    void configureFaultInjectionProvider(IFaultInjectorProvider injectorProvider) {
        this.database.getClient().configureFaultInjectorProvider(injectorProvider);
    }

    synchronized IFaultInjectorProvider getOrConfigureFaultInjectorProvider(Callable<IFaultInjectorProvider> injectorProviderCallable) {
        Preconditions.checkNotNull(injectorProviderCallable, "Argument 'injectorProviderCallable' can not be null");
        try {
            if (this.faultInjectorProvider == null) {
                this.faultInjectorProvider = injectorProviderCallable.call();
                this.configureFaultInjectionProvider(this.faultInjectorProvider);
            }
            return this.faultInjectorProvider;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to configure fault injector provider " + e);
        }
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosAsyncContainerHelper.setCosmosAsyncContainerAccessor(new ImplementationBridgeHelpers.CosmosAsyncContainerHelper.CosmosAsyncContainerAccessor(){

            @Override
            public <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosAsyncContainer cosmosAsyncContainer, CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
                return cosmosAsyncContainer.queryChangeFeedInternalFunc(cosmosChangeFeedRequestOptions, classType);
            }

            @Override
            public void enableLocalThroughputControlGroup(CosmosAsyncContainer cosmosAsyncContainer, ThroughputControlGroupConfig groupConfig, Mono<Integer> throughputQueryMono) {
                cosmosAsyncContainer.enableLocalThroughputControlGroup(groupConfig, throughputQueryMono);
            }

            @Override
            public void enableGlobalThroughputControlGroup(CosmosAsyncContainer cosmosAsyncContainer, ThroughputControlGroupConfig groupConfig, GlobalThroughputControlConfig globalControlConfig, Mono<Integer> throughputQueryMono) {
                cosmosAsyncContainer.enableGlobalThroughputControlGroup(groupConfig, globalControlConfig, throughputQueryMono);
            }

            @Override
            public IFaultInjectorProvider getOrConfigureFaultInjectorProvider(CosmosAsyncContainer cosmosAsyncContainer, Callable<IFaultInjectorProvider> injectorProviderCallable) {
                return cosmosAsyncContainer.getOrConfigureFaultInjectorProvider(injectorProviderCallable);
            }

            @Override
            public <T> Mono<FeedResponse<T>> readMany(CosmosAsyncContainer cosmosAsyncContainer, List<CosmosItemIdentity> itemIdentityList, CosmosQueryRequestOptions requestOptions, Class<T> classType) {
                return cosmosAsyncContainer.readMany(itemIdentityList, requestOptions, classType);
            }

            @Override
            public <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFunc(CosmosAsyncContainer cosmosAsyncContainer, SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
                return cosmosAsyncContainer.queryItemsInternalFunc(sqlQuerySpec, cosmosQueryRequestOptions, classType);
            }

            @Override
            public <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFuncWithMonoSqlQuerySpec(CosmosAsyncContainer cosmosAsyncContainer, Mono<SqlQuerySpec> sqlQuerySpecMono, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
                return cosmosAsyncContainer.queryItemsInternalFunc(sqlQuerySpecMono, cosmosQueryRequestOptions, classType);
            }
        });
    }

    static {
        CosmosAsyncContainer.initialize();
    }
}

