/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponseDiagnostics {
    static final Logger logger = LoggerFactory.getLogger(StoreResponseDiagnostics.class);
    private final String partitionKeyRangeId;
    private final String sessionTokenAsString;
    private final double requestCharge;
    private final String activityId;
    private final String correlatedActivityId;
    private final int statusCode;
    private final int subStatusCode;
    private final int requestPayloadLength;
    private final int responsePayloadLength;
    private final RequestTimeline requestTimeline;
    private final RntbdChannelAcquisitionTimeline channelAcquisitionTimeline;
    private final RntbdEndpointStatistics rntbdEndpointStatistics;
    private final RntbdChannelStatistics rntbdChannelStatistics;
    private final int rntbdRequestLength;
    private final int rntbdResponseLength;
    private final String exceptionMessage;
    private final String exceptionResponseHeaders;
    private final List<String> replicaStatusList;
    private final String faultInjectionRuleId;
    private final List<String> faultInjectionEvaluationResults;

    public static StoreResponseDiagnostics createStoreResponseDiagnostics(StoreResponse storeResponse, RxDocumentServiceRequest rxDocumentServiceRequest) {
        return new StoreResponseDiagnostics(storeResponse, rxDocumentServiceRequest);
    }

    public static StoreResponseDiagnostics createStoreResponseDiagnostics(CosmosException cosmosException, RxDocumentServiceRequest rxDocumentServiceRequest) {
        return new StoreResponseDiagnostics(cosmosException, rxDocumentServiceRequest);
    }

    private StoreResponseDiagnostics(StoreResponse storeResponse, RxDocumentServiceRequest rxDocumentServiceRequest) {
        String rspPkRangeId = storeResponse.getPartitionKeyRangeId();
        this.partitionKeyRangeId = !Strings.isNullOrWhiteSpace(rspPkRangeId) ? rspPkRangeId : rxDocumentServiceRequest.getHeaders().get("x-ms-documentdb-partitionkeyrangeid");
        this.activityId = storeResponse.getActivityId();
        this.correlatedActivityId = storeResponse.getCorrelatedActivityId();
        this.requestCharge = storeResponse.getRequestCharge();
        this.sessionTokenAsString = storeResponse.getSessionTokenString();
        this.statusCode = storeResponse.getStatus();
        this.subStatusCode = storeResponse.getSubStatusCode();
        this.requestPayloadLength = storeResponse.getRequestPayloadLength();
        this.responsePayloadLength = storeResponse.getResponseBodyLength();
        this.requestTimeline = storeResponse.getRequestTimeline();
        this.channelAcquisitionTimeline = storeResponse.getChannelAcquisitionTimeline();
        this.rntbdEndpointStatistics = storeResponse.getEndpointStatistics();
        this.rntbdChannelStatistics = storeResponse.getChannelStatistics();
        this.rntbdRequestLength = storeResponse.getRntbdRequestLength();
        this.rntbdResponseLength = storeResponse.getRntbdResponseLength();
        this.exceptionMessage = null;
        this.exceptionResponseHeaders = null;
        this.replicaStatusList = storeResponse.getReplicaStatusList();
        this.faultInjectionRuleId = storeResponse.getFaultInjectionRuleId();
        this.faultInjectionEvaluationResults = storeResponse.getFaultInjectionRuleEvaluationResults();
    }

    private StoreResponseDiagnostics(CosmosException e, RxDocumentServiceRequest rxDocumentServiceRequest) {
        String rspPkRangeId = BridgeInternal.getPartitionKeyRangeId(e);
        this.partitionKeyRangeId = !Strings.isNullOrWhiteSpace(rspPkRangeId) ? rspPkRangeId : rxDocumentServiceRequest.getHeaders().get("x-ms-documentdb-partitionkeyrangeid");
        this.activityId = e.getActivityId();
        this.correlatedActivityId = e.getResponseHeaders().get("x-ms-cosmos-correlated-activityid");
        this.requestCharge = e.getRequestCharge();
        this.sessionTokenAsString = e.getResponseHeaders().get("x-ms-session-token");
        this.statusCode = e.getStatusCode();
        this.subStatusCode = e.getSubStatusCode();
        this.requestPayloadLength = BridgeInternal.getRequestBodyLength(e);
        this.responsePayloadLength = BridgeInternal.getRntbdResponseLength(e);
        this.requestTimeline = BridgeInternal.getRequestTimeline(e);
        this.channelAcquisitionTimeline = BridgeInternal.getChannelAcqusitionTimeline(e);
        this.rntbdEndpointStatistics = BridgeInternal.getServiceEndpointStatistics(e);
        this.rntbdChannelStatistics = ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().getRntbdChannelStatistics(e);
        this.rntbdRequestLength = BridgeInternal.getRntbdRequestLength(e);
        this.rntbdResponseLength = BridgeInternal.getRntbdResponseLength(e);
        this.exceptionMessage = BridgeInternal.getInnerErrorMessage(e);
        this.exceptionResponseHeaders = e.getResponseHeaders() != null ? e.getResponseHeaders().toString() : null;
        this.replicaStatusList = ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().getReplicaStatusList(e);
        this.faultInjectionRuleId = ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().getFaultInjectionRuleId(e);
        this.faultInjectionEvaluationResults = ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().getFaultInjectionEvaluationResults(e);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public int getRequestPayloadLength() {
        return this.requestPayloadLength;
    }

    public int getResponsePayloadLength() {
        return this.responsePayloadLength;
    }

    public RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    public RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.channelAcquisitionTimeline;
    }

    public RntbdEndpointStatistics getRntbdEndpointStatistics() {
        return this.rntbdEndpointStatistics;
    }

    public RntbdChannelStatistics getRntbdChannelStatistics() {
        return this.rntbdChannelStatistics;
    }

    public int getRntbdRequestLength() {
        return this.rntbdRequestLength;
    }

    public int getRntbdResponseLength() {
        return this.rntbdResponseLength;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public String getSessionTokenAsString() {
        return this.sessionTokenAsString;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getCorrelatedActivityId() {
        return this.correlatedActivityId;
    }

    public String getExceptionResponseHeaders() {
        return this.exceptionResponseHeaders;
    }

    public String getFaultInjectionRuleId() {
        return this.faultInjectionRuleId;
    }

    public List<String> getFaultInjectionEvaluationResults() {
        return this.faultInjectionEvaluationResults;
    }

    public List<String> getReplicaStatusList() {
        return this.replicaStatusList;
    }
}

