/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DistinctQueryType;
import com.azure.cosmos.implementation.query.OrderedDistinctMap;
import com.azure.cosmos.implementation.query.UnorderedDistinctMap;
import com.azure.cosmos.implementation.routing.UInt128;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public abstract class DistinctMap {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    public static DistinctMap create(DistinctQueryType distinctQueryType, UInt128 previousHash) {
        switch (distinctQueryType) {
            case NONE: {
                throw new IllegalArgumentException("distinct query type cannot be None");
            }
            case UNORDERED: {
                return new UnorderedDistinctMap();
            }
            case ORDERED: {
                return new OrderedDistinctMap(previousHash);
            }
        }
        throw new IllegalArgumentException("Unrecognized DistinctQueryType");
    }

    public abstract boolean add(Object var1, Utils.ValueHolder<UInt128> var2);

    String getSortedJsonStringValueFromResource(Resource resource) {
        try {
            Object obj = OBJECT_MAPPER.treeToValue((TreeNode)resource.getPropertyBag(), Object.class);
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to obtain serialized sorted json");
        }
    }
}

