/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Comparator;

@JsonIgnoreProperties(value={"empty", "singleValue", "map", "propertyBag"})
@JsonPropertyOrder(value={"min", "max", "isMinInclusive", "isMaxInclusive"})
public final class Range<T extends Comparable<T>>
extends JsonSerializable {
    private static final String MIN_PROPERTY = "min";
    private static final String MAX_PROPERTY = "max";
    private static final String IS_MIN_INCLUSIVE_PROPERTY = "isMinInclusive";
    private static final String IS_MAX_INCLUSIVE_PROPERTY = "isMaxInclusive";
    private T minValue;
    private T maxValue;

    public Range(ObjectNode objectNode) {
        super(objectNode);
    }

    public Range() {
    }

    public Range(String jsonString) {
        super(jsonString);
    }

    public Range(T min, T max, boolean isMinInclusive, boolean isMaxInclusive) {
        this.setMin(min);
        this.setMax(max);
        this.setMinInclusive(isMinInclusive);
        this.setMaxInclusive(isMaxInclusive);
    }

    public static <T extends Comparable<T>> Range<T> getPointRange(T value) {
        return new Range<T>(value, value, true, true);
    }

    public static <T extends Comparable<T>> Range<T> getEmptyRange(T value) {
        return new Range<T>(value, value, true, false);
    }

    public static <T extends Comparable<T>> boolean checkOverlapping(Range<T> range1, Range<T> range2) {
        if (range1 == null || range2 == null || range1.isEmpty() || range2.isEmpty()) {
            return false;
        }
        int cmp1 = range1.getMin().compareTo(range2.getMax());
        int cmp2 = range2.getMin().compareTo(range1.getMax());
        if (cmp1 <= 0 && cmp2 <= 0) {
            return (cmp1 != 0 || range1.isMinInclusive() && range2.isMaxInclusive()) && (cmp2 != 0 || range2.isMinInclusive() && range1.isMaxInclusive());
        }
        return false;
    }

    public T getMin() {
        if (this.minValue == null) {
            this.minValue = (Comparable)super.get(MIN_PROPERTY);
        }
        return this.minValue;
    }

    public void setMin(T min) {
        this.minValue = min;
        BridgeInternal.setProperty(this, MIN_PROPERTY, min);
    }

    public T getMax() {
        if (this.maxValue == null) {
            this.maxValue = (Comparable)super.get(MAX_PROPERTY);
        }
        return this.maxValue;
    }

    public void setMax(T max) {
        this.maxValue = max;
        BridgeInternal.setProperty(this, MAX_PROPERTY, max);
    }

    @JsonProperty(value="isMinInclusive")
    public boolean isMinInclusive() {
        return !Boolean.FALSE.equals(super.getBoolean(IS_MIN_INCLUSIVE_PROPERTY));
    }

    public void setMinInclusive(boolean isMinInclusive) {
        if (isMinInclusive) {
            BridgeInternal.remove(this, IS_MIN_INCLUSIVE_PROPERTY);
        } else {
            BridgeInternal.setProperty(this, IS_MIN_INCLUSIVE_PROPERTY, false);
        }
    }

    @JsonProperty(value="isMaxInclusive")
    public boolean isMaxInclusive() {
        return Boolean.TRUE.equals(super.getBoolean(IS_MAX_INCLUSIVE_PROPERTY));
    }

    public void setMaxInclusive(boolean isMaxInclusive) {
        if (isMaxInclusive) {
            BridgeInternal.setProperty(this, IS_MAX_INCLUSIVE_PROPERTY, true);
        } else {
            BridgeInternal.remove(this, IS_MAX_INCLUSIVE_PROPERTY);
        }
    }

    public boolean isSingleValue() {
        return this.isMinInclusive() && this.isMaxInclusive() && this.getMin().compareTo(this.getMax()) == 0;
    }

    public boolean isEmpty() {
        return this.getMin().compareTo(this.getMax()) == 0 && (!this.isMinInclusive() || !this.isMaxInclusive());
    }

    public boolean contains(T value) {
        int minToValueRelation = this.getMin().compareTo(value);
        int maxToValueRelation = this.getMax().compareTo(value);
        return (this.isMinInclusive() && minToValueRelation <= 0 || !this.isMinInclusive() && minToValueRelation < 0) && (this.isMaxInclusive() && maxToValueRelation >= 0 || !this.isMaxInclusive() && maxToValueRelation > 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Range otherRange = (Range)obj;
        return this.getMin().compareTo(otherRange.getMin()) == 0 && this.getMax().compareTo(otherRange.getMax()) == 0 && this.isMinInclusive() == otherRange.isMinInclusive() && this.isMaxInclusive() == otherRange.isMaxInclusive();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash = hash * 397 ^ this.getMin().hashCode();
        hash = hash * 397 ^ this.getMax().hashCode();
        hash = hash * 397 ^ Boolean.compare(this.isMinInclusive(), false);
        hash = hash * 397 ^ Boolean.compare(this.isMaxInclusive(), false);
        return hash;
    }

    public static class MaxComparator<T extends Comparable<T>>
    implements Comparator<Range<T>>,
    Serializable {
        private static final long serialVersionUID = -3399886607526260054L;

        @Override
        public int compare(Range<T> range1, Range<T> range2) {
            int result = range1.getMax().compareTo(range2.getMax());
            if (result != 0 || range1.isMaxInclusive() == range2.isMaxInclusive()) {
                return result;
            }
            return range1.isMaxInclusive() ? 1 : -1;
        }
    }

    public static class MinComparator<T extends Comparable<T>>
    implements Comparator<Range<T>>,
    Serializable {
        private static final long serialVersionUID = 8934048827394132143L;

        @Override
        public int compare(Range<T> range1, Range<T> range2) {
            int result = range1.getMin().compareTo(range2.getMin());
            if (result != 0 || range1.isMinInclusive() == range2.isMinInclusive()) {
                return result;
            }
            return range1.isMinInclusive() ? -1 : 1;
        }
    }
}

