/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosResponse;
import java.time.Instant;

public class CosmosContainerResponse
extends CosmosResponse<CosmosContainerProperties> {
    CosmosContainerResponse(ResourceResponse<DocumentCollection> response) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty(bodyAsString)) {
            super.setProperties(null);
            super.setProperties(null);
        } else {
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
            Instant serializationStartTime = Instant.now();
            CosmosContainerProperties props = new CosmosContainerProperties(bodyAsString);
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.CONTAINER_DESERIALIZATION);
            serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
            super.setProperties(props);
        }
    }

    public long getIndexTransformationProgress() {
        return this.resourceResponseWrapper.getIndexTransformationProgress();
    }

    long getLazyIndexingProgress() {
        return this.resourceResponseWrapper.getLazyIndexingProgress();
    }

    @Override
    public CosmosContainerProperties getProperties() {
        return (CosmosContainerProperties)super.getProperties();
    }
}

