/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.ContainerChildResourceType;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PermissionMode;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosPermissionProperties {
    private Permission permission;
    private String databaseName;
    private String resourceToken;
    private String permissionName;
    private String containerName;
    private String resourceName;
    private ContainerChildResourceType resourceKind;
    private PermissionMode permissionMode;
    private PartitionKey resourcePartitionKey;

    public CosmosPermissionProperties() {
    }

    public CosmosPermissionProperties setId(String id) {
        this.permissionName = id;
        if (this.permission != null) {
            this.permission.setId(id);
        }
        return this;
    }

    CosmosPermissionProperties(String jsonString) {
        this.permission = new Permission(jsonString);
        this.permissionName = this.permission.getId();
        this.permissionMode = this.permission.getPermissionMode();
        this.resourcePartitionKey = this.permission.getResourcePartitionKey();
        this.resourceToken = this.permission.getToken();
        String[] parts = StringUtils.split(Utils.trimBeginningAndEndingSlashes(this.permission.getResourceLink()), "/");
        if (parts.length < 4) {
            throw new IllegalArgumentException("jsonString");
        }
        this.databaseName = parts[1];
        this.containerName = parts[3];
        if (parts.length >= 6) {
            this.resourceName = parts[5];
            if ("docs".equalsIgnoreCase(parts[4])) {
                this.resourceKind = ContainerChildResourceType.ITEM;
            } else if ("sprocs".equalsIgnoreCase(parts[4])) {
                this.resourceKind = ContainerChildResourceType.STORED_PROCEDURE;
            } else if ("udfs".equalsIgnoreCase(parts[4])) {
                this.resourceKind = ContainerChildResourceType.USER_DEFINED_FUNCTION;
            } else if ("triggers".equalsIgnoreCase(parts[4])) {
                this.resourceKind = ContainerChildResourceType.TRIGGER;
            } else {
                throw new IllegalArgumentException("jsonString");
            }
        }
    }

    public CosmosPermissionProperties setContainerName(String containerName) {
        this.containerName = containerName;
        if (this.permission != null) {
            this.permission.setResourceLink(this.databaseName);
            this.resourceToken = null;
        }
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public ContainerChildResourceType getResourceKind() {
        return this.resourceKind;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public CosmosPermissionProperties setResourcePath(ContainerChildResourceType resourceKind, String resourceName) {
        this.resourceKind = resourceKind;
        this.resourceName = resourceName;
        if (this.permission != null) {
            this.permission.setResourceLink(this.databaseName);
            this.resourceToken = null;
        }
        return this;
    }

    public PermissionMode getPermissionMode() {
        return this.permissionMode;
    }

    public CosmosPermissionProperties setPermissionMode(PermissionMode permissionMode) {
        this.permissionMode = permissionMode;
        if (this.permission != null) {
            this.permission.setPermissionMode(permissionMode);
            this.resourceToken = null;
        }
        return this;
    }

    public PartitionKey getResourcePartitionKey() {
        return this.resourcePartitionKey;
    }

    public CosmosPermissionProperties setResourcePartitionKey(PartitionKey partitionKey) {
        this.resourcePartitionKey = partitionKey;
        if (this.permission != null) {
            this.permission.setResourcePartitionKey(partitionKey);
            this.resourceToken = null;
        }
        return this;
    }

    Resource getResource() {
        return this.permission;
    }

    String getResourcePath(String databaseName) {
        StringBuilder resourcePrefixPath = new StringBuilder();
        if (databaseName == null || databaseName.isEmpty()) {
            throw new IllegalArgumentException("databaseName");
        }
        resourcePrefixPath.append("dbs").append("/").append(databaseName);
        if (this.containerName == null || this.containerName.isEmpty()) {
            throw new IllegalArgumentException("containerName");
        }
        resourcePrefixPath.append("/").append("colls").append("/").append(this.containerName);
        if (this.resourceName != null && !this.resourceName.isEmpty()) {
            switch (this.resourceKind) {
                case ITEM: {
                    resourcePrefixPath.append("/").append("docs");
                    break;
                }
                case STORED_PROCEDURE: {
                    resourcePrefixPath.append("/").append("sprocs");
                    break;
                }
                case USER_DEFINED_FUNCTION: {
                    resourcePrefixPath.append("/").append("udfs");
                    break;
                }
                case TRIGGER: {
                    resourcePrefixPath.append("/").append("triggers");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("resourceKind");
                }
            }
            resourcePrefixPath.append("/").append(this.resourceName);
        }
        return resourcePrefixPath.toString();
    }

    Permission getResource(String databaseName) {
        if (this.permission != null) {
            return this.permission;
        }
        Permission permission = new Permission();
        permission.setId(this.permissionName);
        permission.setPermissionMode(this.permissionMode);
        permission.setResourceLink(this.getResourcePath(databaseName));
        if (this.resourcePartitionKey != null) {
            permission.setResourcePartitionKey(this.resourcePartitionKey);
        }
        return permission;
    }

    public String getId() {
        return this.permissionName;
    }

    public Instant getTimestamp() {
        if (this.permission != null) {
            return this.permission.getTimestamp();
        }
        return null;
    }

    public String getETag() {
        if (this.permission != null) {
            return this.permission.getETag();
        }
        return null;
    }

    public String getToken() {
        return this.resourceToken;
    }

    Permission getPermission(String databaseName) {
        return this.getResource(databaseName);
    }

    Permission getPermission() {
        return this.permission;
    }

    static List<CosmosPermissionProperties> getPermissions(List<Permission> results) {
        return results.stream().map(permission -> new CosmosPermissionProperties(permission.toJson())).collect(Collectors.toList());
    }
}

