/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.ClientEncryptionKey;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.CosmosResourceType;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Index;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.ChangeFeedPolicy;
import com.azure.cosmos.models.CompositePath;
import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import com.azure.cosmos.models.CosmosBulkItemResponse;
import com.azure.cosmos.models.CosmosBulkOperationResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosConflictRequestOptions;
import com.azure.cosmos.models.CosmosConflictResponse;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemOperationType;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.CosmosPermissionResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.PartitionKeyDefinitionVersion;
import com.azure.cosmos.models.PriorityLevel;
import com.azure.cosmos.models.SpatialSpec;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.models.UniqueKey;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public final class ModelBridgeInternal {
    private ModelBridgeInternal() {
    }

    public static CosmosConflictResponse createCosmosConflictResponse(ResourceResponse<Conflict> response) {
        return new CosmosConflictResponse(response);
    }

    public static ConsistencyLevel getConsistencyLevel(CosmosItemRequestOptions options) {
        return options.getConsistencyLevel();
    }

    public static CosmosContainerResponse createCosmosContainerResponse(ResourceResponse<DocumentCollection> response) {
        return new CosmosContainerResponse(response);
    }

    public static CosmosDatabaseResponse createCosmosDatabaseResponse(ResourceResponse<Database> response) {
        return new CosmosDatabaseResponse(response);
    }

    public static <T> CosmosItemResponse<T> createCosmosAsyncItemResponse(ResourceResponse<Document> response, Class<T> classType, ItemDeserializer itemDeserializer) {
        return new CosmosItemResponse<T>(response, classType, itemDeserializer);
    }

    public static CosmosItemResponse<Object> createCosmosAsyncItemResponseWithObjectType(ResourceResponse<Document> response) {
        return new CosmosItemResponse<Object>(response, Object.class, null);
    }

    public static CosmosPermissionResponse createCosmosPermissionResponse(ResourceResponse<Permission> response) {
        return new CosmosPermissionResponse(response);
    }

    public static CosmosStoredProcedureResponse createCosmosStoredProcedureResponse(ResourceResponse<StoredProcedure> response) {
        return new CosmosStoredProcedureResponse(response);
    }

    public static CosmosStoredProcedureResponse createCosmosStoredProcedureResponse(StoredProcedureResponse response) {
        return new CosmosStoredProcedureResponse(response);
    }

    public static CosmosStoredProcedureProperties createCosmosStoredProcedureProperties(String jsonString) {
        return new CosmosStoredProcedureProperties(jsonString);
    }

    public static CosmosPermissionProperties createCosmosPermissionProperties(String jsonString) {
        return new CosmosPermissionProperties(jsonString);
    }

    public static CosmosTriggerResponse createCosmosTriggerResponse(ResourceResponse<Trigger> response) {
        return new CosmosTriggerResponse(response);
    }

    public static CosmosUserDefinedFunctionResponse createCosmosUserDefinedFunctionResponse(ResourceResponse<UserDefinedFunction> response) {
        return new CosmosUserDefinedFunctionResponse(response);
    }

    public static CosmosUserResponse createCosmosUserResponse(ResourceResponse<User> response) {
        return new CosmosUserResponse(response);
    }

    public static CosmosClientEncryptionKeyResponse createCosmosClientEncryptionKeyResponse(ResourceResponse<ClientEncryptionKey> response) {
        return new CosmosClientEncryptionKeyResponse(response);
    }

    public static List<CosmosConflictProperties> getCosmosConflictPropertiesFromV2Results(List<Conflict> results) {
        return CosmosConflictProperties.getFromV2Results(results);
    }

    public static DocumentCollection getV2Collection(CosmosContainerProperties containerProperties) {
        return containerProperties.getV2Collection();
    }

    public static List<CosmosContainerProperties> getCosmosContainerPropertiesFromV2Results(List<DocumentCollection> results) {
        return CosmosContainerProperties.getFromV2Results(results);
    }

    public static List<CosmosDatabaseProperties> getCosmosDatabasePropertiesFromV2Results(List<Database> results) {
        return CosmosDatabaseProperties.getFromV2Results(results);
    }

    public static <T> InternalObjectNode getInternalObjectNode(CosmosItemResponse<T> cosmosItemResponse) {
        return cosmosItemResponse.getProperties();
    }

    public static Permission getPermission(CosmosPermissionProperties permissionProperties, String databaseName) {
        return permissionProperties.getPermission(databaseName);
    }

    public static Permission getPermission(CosmosPermissionProperties permissionProperties) {
        return permissionProperties.getPermission();
    }

    public static List<CosmosPermissionProperties> getCosmosPermissionPropertiesFromResults(List<Permission> results) {
        return CosmosPermissionProperties.getPermissions(results);
    }

    public static List<CosmosStoredProcedureProperties> getCosmosStoredProcedurePropertiesFromV2Results(List<StoredProcedure> results) {
        return CosmosStoredProcedureProperties.getFromV2Results(results);
    }

    public static List<CosmosTriggerProperties> getCosmosTriggerPropertiesFromV2Results(List<Trigger> results) {
        return CosmosTriggerProperties.getFromV2Results(results);
    }

    public static List<CosmosUserDefinedFunctionProperties> getCosmosUserDefinedFunctionPropertiesFromV2Results(List<UserDefinedFunction> results) {
        return CosmosUserDefinedFunctionProperties.getFromV2Results(results);
    }

    public static User getV2User(CosmosUserProperties cosmosUserProperties) {
        return cosmosUserProperties.getV2User();
    }

    public static List<CosmosUserProperties> getCosmosUserPropertiesFromV2Results(List<User> results) {
        return CosmosUserProperties.getFromV2Results(results);
    }

    public static ClientEncryptionKey getClientEncryptionKey(CosmosClientEncryptionKeyProperties cosmosClientEncryptionKeyProperties) {
        return cosmosClientEncryptionKeyProperties.getClientEncryptionKey();
    }

    public static List<CosmosClientEncryptionKeyProperties> getClientEncryptionKeyPropertiesList(List<ClientEncryptionKey> results) {
        return CosmosClientEncryptionKeyProperties.getClientEncryptionKeys(results);
    }

    public static RequestOptions toRequestOptions(CosmosConflictRequestOptions cosmosConflictRequestOptions) {
        return cosmosConflictRequestOptions.toRequestOptions();
    }

    public static RequestOptions toRequestOptions(CosmosContainerRequestOptions cosmosContainerRequestOptions) {
        return cosmosContainerRequestOptions.toRequestOptions();
    }

    public static RequestOptions toRequestOptions(CosmosDatabaseRequestOptions cosmosDatabaseRequestOptions) {
        return cosmosDatabaseRequestOptions.toRequestOptions();
    }

    public static CosmosDatabaseRequestOptions setThroughputProperties(CosmosDatabaseRequestOptions cosmosDatabaseRequestOptions, ThroughputProperties throughputProperties) {
        return cosmosDatabaseRequestOptions.setThroughputProperties(throughputProperties);
    }

    public static CosmosContainerRequestOptions setThroughputProperties(CosmosContainerRequestOptions containerRequestOptions, ThroughputProperties throughputProperties) {
        return containerRequestOptions.setThroughputProperties(throughputProperties);
    }

    public static Offer updateOfferFromProperties(Offer offer, ThroughputProperties properties) {
        return properties.updateOfferFromProperties(offer);
    }

    public static CosmosItemRequestOptions setPartitionKey(CosmosItemRequestOptions cosmosItemRequestOptions, PartitionKey partitionKey) {
        return cosmosItemRequestOptions.setPartitionKey(partitionKey);
    }

    public static RequestOptions toRequestOptions(CosmosItemRequestOptions cosmosItemRequestOptions) {
        return cosmosItemRequestOptions.toRequestOptions();
    }

    public static RequestOptions toRequestOptions(CosmosPatchItemRequestOptions cosmosPatchItemRequestOptions) {
        return cosmosPatchItemRequestOptions.toRequestOptions();
    }

    public static CosmosItemRequestOptions createCosmosItemRequestOptions(PartitionKey partitionKey) {
        return new CosmosItemRequestOptions(partitionKey);
    }

    public static RequestOptions toRequestOptions(CosmosPermissionRequestOptions cosmosPermissionRequestOptions) {
        return cosmosPermissionRequestOptions.toRequestOptions();
    }

    public static RequestOptions toRequestOptions(CosmosStoredProcedureRequestOptions cosmosStoredProcedureRequestOptions) {
        return cosmosStoredProcedureRequestOptions.toRequestOptions();
    }

    public static DatabaseAccount toDatabaseAccount(RxDocumentServiceResponse response) {
        DatabaseAccount account = response.getResource(DatabaseAccount.class);
        Map<String, String> responseHeader = response.getResponseHeaders();
        account.setMaxMediaStorageUsageInMB(Long.parseLong(responseHeader.get("x-ms-max-media-storage-usage-mb")));
        account.setMediaStorageUsageInMB(Long.parseLong(responseHeader.get("x-ms-media-storage-usage-mb")));
        return account;
    }

    public static String getPartitionKeyRangeIdInternal(CosmosQueryRequestOptions options) {
        return options.getPartitionKeyRangeIdInternal();
    }

    public static CosmosQueryRequestOptions setPartitionKeyRangeIdInternal(CosmosQueryRequestOptions options, String partitionKeyRangeId) {
        return options.setPartitionKeyRangeIdInternal(partitionKeyRangeId);
    }

    public static <T> FeedResponse<T> toFeedResponsePage(RxDocumentServiceResponse response, Function<JsonNode, T> factoryMethod, Class<T> cls) {
        return new FeedResponse<T>(response.getQueryResponse(factoryMethod, cls), response);
    }

    public static <T> FeedResponse<T> toFeedResponsePage(List<T> results, Map<String, String> headers, boolean noChanges) {
        return new FeedResponse<T>(results, headers, noChanges);
    }

    public static <T> FeedResponse<T> toChangeFeedResponsePage(RxDocumentServiceResponse response, Function<JsonNode, T> factoryMethod, Class<T> cls) {
        return new FeedResponse(ModelBridgeInternal.noChanges(response) ? Collections.emptyList() : response.getQueryResponse(factoryMethod, cls), response.getResponseHeaders(), ModelBridgeInternal.noChanges(response));
    }

    public static <T> boolean noChanges(FeedResponse<T> page) {
        return page.nochanges;
    }

    public static <T extends Resource> boolean noChanges(RxDocumentServiceResponse rsp) {
        return rsp.getStatusCode() == 304;
    }

    public static <T> FeedResponse<T> createFeedResponse(List<T> results, Map<String, String> headers) {
        return new FeedResponse<T>(results, headers);
    }

    public static <T> FeedResponse<T> createFeedResponseWithQueryMetrics(List<T> results, Map<String, String> headers, ConcurrentMap<String, QueryMetrics> queryMetricsMap, QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext, boolean useEtagAsContinuation, boolean isNoChanges) {
        FeedResponse<T> feedResponse = new FeedResponse<T>(results, headers, queryMetricsMap, useEtagAsContinuation, isNoChanges);
        feedResponse.setQueryPlanDiagnosticsContext(diagnosticsContext);
        return feedResponse;
    }

    public static <T> ConcurrentMap<String, QueryMetrics> queryMetricsMap(FeedResponse<T> feedResponse) {
        return feedResponse.queryMetricsMap();
    }

    public static <T> ConcurrentMap<String, QueryMetrics> queryMetrics(FeedResponse<T> feedResponse) {
        return feedResponse.queryMetrics();
    }

    public static <T> QueryInfo.QueryPlanDiagnosticsContext getQueryPlanDiagnosticsContext(FeedResponse<T> feedResponse) {
        return feedResponse.getQueryPlanDiagnosticsContext();
    }

    public static String toLower(RequestVerb verb) {
        return verb.toLowerCase();
    }

    public static boolean isV2(PartitionKeyDefinition pkd) {
        return pkd.getVersion() != null && PartitionKeyDefinitionVersion.V2.val == pkd.getVersion().val;
    }

    public static PartitionKeyInternal getNonePartitionKey(PartitionKeyDefinition partitionKeyDefinition) {
        return partitionKeyDefinition.getNonePartitionKeyValue();
    }

    public static PartitionKeyInternal getPartitionKeyInternal(PartitionKey partitionKey) {
        return partitionKey.getInternalPartitionKey();
    }

    public static PartitionKey partitionKeyfromJsonString(String jsonString) {
        return PartitionKey.fromJsonString(jsonString);
    }

    public static Object getPartitionKeyObject(PartitionKey right) {
        return right.getKeyObject();
    }

    public static String getAltLink(Resource resource) {
        return resource.getAltLink();
    }

    public static void setAltLink(Resource resource, String altLink) {
        resource.setAltLink(altLink);
    }

    public static void setResourceId(Resource resource, String resourceId) {
        resource.setResourceId(resourceId);
    }

    public static void setResourceSelfLink(Resource resource, String selfLink) {
        resource.setSelfLink(selfLink);
    }

    public static void setTimestamp(Resource resource, Instant date) {
        resource.setTimestamp(date);
    }

    public static <T> void setProperty(JsonSerializable jsonSerializable, String propertyName, T value) {
        jsonSerializable.set(propertyName, value);
    }

    public static ObjectNode getObjectNodeFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        return jsonSerializable.getObject(propertyName);
    }

    public static void removeFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        jsonSerializable.remove(propertyName);
    }

    public static Object getValue(JsonNode value) {
        return JsonSerializable.getValue(value);
    }

    public static Map<String, Object> getMapFromJsonSerializable(JsonSerializable jsonSerializable) {
        return jsonSerializable.getMap();
    }

    public static CosmosResourceType fromServiceSerializedFormat(String cosmosResourceType) {
        return CosmosResourceType.fromServiceSerializedFormat(cosmosResourceType);
    }

    public static Boolean getBooleanFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        return jsonSerializable.getBoolean(propertyName);
    }

    public static Double getDoubleFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        return jsonSerializable.getDouble(propertyName);
    }

    public static Object getObjectByPathFromJsonSerializable(JsonSerializable jsonSerializable, List<String> propertyNames) {
        return jsonSerializable.getObjectByPath(propertyNames);
    }

    public static ByteBuffer serializeJsonToByteBuffer(JsonSerializable jsonSerializable) {
        return jsonSerializable.serializeJsonToByteBuffer();
    }

    public static <T> T toObjectFromJsonSerializable(JsonSerializable jsonSerializable, Class<T> c) {
        return jsonSerializable.toObject(c);
    }

    public static ByteBuffer serializeJsonToByteBuffer(JsonSerializable jsonSerializable, ObjectMapper objectMapper) {
        return jsonSerializable.serializeJsonToByteBuffer(objectMapper);
    }

    public static Object getObjectFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        return jsonSerializable.get(propertyName);
    }

    public static String getStringFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        return jsonSerializable.getString(propertyName);
    }

    public static Integer getIntFromJsonSerializable(JsonSerializable jsonSerializable, String propertyName) {
        return jsonSerializable.getInt(propertyName);
    }

    public static String toJsonFromJsonSerializable(JsonSerializable jsonSerializable) {
        return jsonSerializable.toJson();
    }

    public static ObjectNode getPropertyBagFromJsonSerializable(JsonSerializable jsonSerializable) {
        if (jsonSerializable == null) {
            return null;
        }
        return jsonSerializable.getPropertyBag();
    }

    public static void setQueryRequestOptionsContinuationTokenAndMaxItemCount(CosmosQueryRequestOptions options, String continuationToken, Integer maxItemCount) {
        options.setRequestContinuation(continuationToken);
        options.setMaxItemCount(maxItemCount);
    }

    public static void setQueryRequestOptionsContinuationToken(CosmosQueryRequestOptions cosmosQueryRequestOptions, String continuationToken) {
        cosmosQueryRequestOptions.setRequestContinuation(continuationToken);
    }

    public static void setQueryRequestOptionsMaxItemCount(CosmosQueryRequestOptions cosmosQueryRequestOptions, Integer maxItemCount) {
        cosmosQueryRequestOptions.setMaxItemCount(maxItemCount);
    }

    public static CosmosChangeFeedRequestOptions getEffectiveChangeFeedRequestOptions(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, CosmosPagedFluxOptions pagedFlexOptions) {
        return cosmosChangeFeedRequestOptions.withCosmosPagedFluxOptions(pagedFlexOptions);
    }

    public static ByteBuffer serializeJsonToByteBuffer(SqlQuerySpec sqlQuerySpec) {
        sqlQuerySpec.populatePropertyBag();
        return sqlQuerySpec.getJsonSerializable().serializeJsonToByteBuffer();
    }

    public static <T> T instantiateByObjectNode(ObjectNode objectNode, Class<T> c) {
        try {
            return c.getDeclaredConstructor(ObjectNode.class).newInstance(objectNode);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> void populatePropertyBag(T t) {
        if (t instanceof JsonSerializable) {
            ((JsonSerializable)t).populatePropertyBag();
        } else if (t instanceof CompositePath) {
            ((CompositePath)t).populatePropertyBag();
        } else if (t instanceof ConflictResolutionPolicy) {
            ((ConflictResolutionPolicy)t).populatePropertyBag();
        } else if (t instanceof ChangeFeedPolicy) {
            ((ChangeFeedPolicy)t).populatePropertyBag();
        } else if (t instanceof ExcludedPath) {
            ((ExcludedPath)t).populatePropertyBag();
        } else if (t instanceof IncludedPath) {
            ((IncludedPath)t).populatePropertyBag();
        } else if (t instanceof IndexingPolicy) {
            ((IndexingPolicy)t).populatePropertyBag();
        } else if (t instanceof PartitionKeyDefinition) {
            ((PartitionKeyDefinition)t).populatePropertyBag();
        } else if (t instanceof SpatialSpec) {
            ((SpatialSpec)t).populatePropertyBag();
        } else if (t instanceof SqlParameter) {
            ((SqlParameter)t).populatePropertyBag();
        } else if (t instanceof SqlQuerySpec) {
            ((SqlQuerySpec)t).populatePropertyBag();
        } else if (t instanceof UniqueKey) {
            ((UniqueKey)t).populatePropertyBag();
        } else if (t instanceof UniqueKeyPolicy) {
            ((UniqueKeyPolicy)t).populatePropertyBag();
        } else {
            throw new IllegalArgumentException("populatePropertyBag method does not exists in class " + t.getClass());
        }
    }

    public static <T> JsonSerializable getJsonSerializable(T t) {
        if (t instanceof JsonSerializable) {
            return (JsonSerializable)t;
        }
        if (t instanceof CompositePath) {
            return ((CompositePath)t).getJsonSerializable();
        }
        if (t instanceof ConflictResolutionPolicy) {
            return ((ConflictResolutionPolicy)t).getJsonSerializable();
        }
        if (t instanceof ChangeFeedPolicy) {
            return ((ChangeFeedPolicy)t).getJsonSerializable();
        }
        if (t instanceof ExcludedPath) {
            return ((ExcludedPath)t).getJsonSerializable();
        }
        if (t instanceof IncludedPath) {
            return ((IncludedPath)t).getJsonSerializable();
        }
        if (t instanceof IndexingPolicy) {
            return ((IndexingPolicy)t).getJsonSerializable();
        }
        if (t instanceof PartitionKeyDefinition) {
            return ((PartitionKeyDefinition)t).getJsonSerializable();
        }
        if (t instanceof SpatialSpec) {
            return ((SpatialSpec)t).getJsonSerializable();
        }
        if (t instanceof SqlParameter) {
            return ((SqlParameter)t).getJsonSerializable();
        }
        if (t instanceof SqlQuerySpec) {
            return ((SqlQuerySpec)t).getJsonSerializable();
        }
        if (t instanceof UniqueKey) {
            return ((UniqueKey)t).getJsonSerializable();
        }
        if (t instanceof UniqueKeyPolicy) {
            return ((UniqueKeyPolicy)t).getJsonSerializable();
        }
        throw new IllegalArgumentException("getJsonSerializable method does not exists in class " + t.getClass());
    }

    public static <T> Resource getResource(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Resource) {
            return (Resource)t;
        }
        if (t instanceof CosmosConflictProperties) {
            return ((CosmosConflictProperties)t).getResource();
        }
        if (t instanceof CosmosContainerProperties) {
            return ((CosmosContainerProperties)t).getResource();
        }
        if (t instanceof CosmosDatabaseProperties) {
            return ((CosmosDatabaseProperties)t).getResource();
        }
        if (t instanceof CosmosPermissionProperties) {
            return ((CosmosPermissionProperties)t).getResource();
        }
        if (t instanceof CosmosStoredProcedureProperties) {
            return ((CosmosStoredProcedureProperties)t).getResource();
        }
        if (t instanceof CosmosTriggerProperties) {
            return ((CosmosTriggerProperties)t).getResource();
        }
        if (t instanceof CosmosUserDefinedFunctionProperties) {
            return ((CosmosUserDefinedFunctionProperties)t).getResource();
        }
        if (t instanceof CosmosUserProperties) {
            return ((CosmosUserProperties)t).getResource();
        }
        if (t instanceof CosmosClientEncryptionKeyProperties) {
            return ((CosmosClientEncryptionKeyProperties)t).getResource();
        }
        throw new IllegalArgumentException("getResource method does not exists in class " + t.getClass());
    }

    public static Offer getOfferFromThroughputProperties(ThroughputProperties properties) {
        return properties.getOffer();
    }

    public static ThroughputResponse createThroughputRespose(ResourceResponse<Offer> offerResourceResponse) {
        return new ThroughputResponse(offerResourceResponse);
    }

    public static void addQueryInfoToFeedResponse(FeedResponse<?> feedResponse, QueryInfo queryInfo) {
        feedResponse.setQueryInfo(queryInfo);
    }

    public static void addQueryPlanDiagnosticsContextToFeedResponse(FeedResponse<?> feedResponse, QueryInfo.QueryPlanDiagnosticsContext queryPlanDiagnosticsContext) {
        feedResponse.setQueryPlanDiagnosticsContext(queryPlanDiagnosticsContext);
    }

    public static boolean getNoChangesFromFeedResponse(FeedResponse<?> response) {
        return response.getNoChanges();
    }

    public static Integer getMaxItemCountFromQueryRequestOptions(CosmosQueryRequestOptions options) {
        return options.getMaxItemCount();
    }

    public static String getRequestContinuationFromQueryRequestOptions(CosmosQueryRequestOptions options) {
        return options.getRequestContinuation();
    }

    public static Map<String, Object> getPropertiesFromChangeFeedRequestOptions(CosmosChangeFeedRequestOptions options) {
        if (options == null) {
            return null;
        }
        return options.getProperties();
    }

    public static Map<String, Object> getPropertiesFromQueryRequestOptions(CosmosQueryRequestOptions options) {
        if (options == null) {
            return null;
        }
        return options.getProperties();
    }

    public static CosmosQueryRequestOptions setQueryRequestOptionsProperties(CosmosQueryRequestOptions options, Map<String, Object> properties) {
        return options.setProperties(properties);
    }

    public static IndexingPolicy createIndexingPolicy(Index[] indexes) {
        return new IndexingPolicy(indexes);
    }

    public static CosmosItemRequestOptions clone(CosmosItemRequestOptions options) {
        return new CosmosItemRequestOptions(options);
    }

    public static <T> int getPayloadLength(CosmosItemResponse<T> cosmosItemResponse) {
        return cosmosItemResponse.responseBodyAsByteArray != null ? cosmosItemResponse.responseBodyAsByteArray.length : 0;
    }

    public static CosmosChangeFeedRequestOptions createChangeFeedRequestOptionsForChangeFeedState(ChangeFeedState state) {
        return CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(state);
    }

    public static <T> void setFeedResponseContinuationToken(String continuationToken, FeedResponse<T> response) {
        Preconditions.checkNotNull(response, "Argument 'response' must not be null.");
        response.setContinuationToken(continuationToken);
    }

    public static ChangeFeedMode getChangeFeedMode(CosmosChangeFeedRequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        return requestOptions.getMode();
    }

    public static ChangeFeedStartFromInternal getChangeFeedStartFromSettings(CosmosChangeFeedRequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        return requestOptions.getStartFromSettings();
    }

    public static boolean getChangeFeedIsSplitHandlingDisabled(CosmosChangeFeedRequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        return requestOptions.isSplitHandlingDisabled();
    }

    public static CosmosChangeFeedRequestOptions disableSplitHandling(CosmosChangeFeedRequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        return requestOptions.disableSplitHandling();
    }

    public static ChangeFeedState getChangeFeedContinuationState(CosmosChangeFeedRequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions, "Argument 'requestOptions' must not be null.");
        return requestOptions.getContinuation();
    }

    public static void setChangeFeedRequestOptionsContinuation(String eTag, CosmosChangeFeedRequestOptions options) {
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        options.setRequestContinuation(eTag);
    }

    public static String getOperationValueForCosmosItemOperationType(CosmosItemOperationType cosmosItemOperationType) {
        return cosmosItemOperationType.getOperationValue();
    }

    public static CosmosBatchResponse createCosmosBatchResponse(int responseStatusCode, int responseSubStatusCode, String errorMessage, Map<String, String> responseHeaders, CosmosDiagnostics cosmosDiagnostics) {
        return new CosmosBatchResponse(responseStatusCode, responseSubStatusCode, errorMessage, responseHeaders, cosmosDiagnostics);
    }

    public static CosmosBatchOperationResult createCosmosBatchResult(String eTag, double requestCharge, ObjectNode resourceObject, int statusCode, Duration retryAfter, int subStatusCode, CosmosItemOperation cosmosItemOperation) {
        return new CosmosBatchOperationResult(eTag, requestCharge, resourceObject, statusCode, retryAfter, subStatusCode, cosmosItemOperation);
    }

    public static void addCosmosBatchResultInResponse(CosmosBatchResponse cosmosBatchResponse, List<CosmosBatchOperationResult> cosmosBatchOperationResults) {
        cosmosBatchResponse.addAll(cosmosBatchOperationResults);
    }

    public static RequestOptions toRequestOptions(CosmosBatchRequestOptions cosmosBatchRequestOptions) {
        return cosmosBatchRequestOptions.toRequestOptions();
    }

    public static CosmosBulkItemResponse createCosmosBulkItemResponse(CosmosBatchOperationResult result, CosmosBatchResponse response) {
        return new CosmosBulkItemResponse(result.getETag(), result.getRequestCharge(), result.getResourceObject(), result.getStatusCode(), result.getRetryAfterDuration(), result.getSubStatusCode(), response.getResponseHeaders(), response.getDiagnostics());
    }

    public static <TContext> CosmosBulkOperationResponse<TContext> createCosmosBulkOperationResponse(CosmosItemOperation operation, CosmosBulkItemResponse response, TContext batchContext) {
        return new CosmosBulkOperationResponse<TContext>(operation, response, batchContext);
    }

    public static <TContext> CosmosBulkOperationResponse<TContext> createCosmosBulkOperationResponse(CosmosItemOperation operation, Exception exception, TContext batchContext) {
        return new CosmosBulkOperationResponse<TContext>(operation, exception, batchContext);
    }

    public static List<PatchOperation> getPatchOperationsFromCosmosPatch(CosmosPatchOperations cosmosPatchOperations) {
        return cosmosPatchOperations.getPatchOperations();
    }

    public static void initializeAllAccessors() {
        CosmosBatch.initialize();
        CosmosBatchOperationResult.initialize();
        CosmosBatchRequestOptions.initialize();
        CosmosBatchResponse.initialize();
        CosmosBulkExecutionOptions.initialize();
        CosmosBulkExecutionThresholdsState.initialize();
        CosmosBulkItemResponse.initialize();
        CosmosChangeFeedRequestOptions.initialize();
        CosmosContainerProperties.initialize();
        CosmosItemRequestOptions.initialize();
        CosmosItemResponse.initialize();
        CosmosPatchOperations.initialize();
        CosmosQueryRequestOptions.initialize();
        FeedResponse.initialize();
        PartitionKey.initialize();
        CosmosClientTelemetryConfig.initialize();
        CosmosContainerIdentity.initialize();
        PriorityLevel.initialize();
    }
}

