/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.FeedOperationState;
import com.azure.cosmos.implementation.guava25.base.Preconditions;

public class CosmosPagedFluxOptions {
    private FeedOperationState operationState;
    private String requestContinuation;
    private Integer maxItemCount;

    public FeedOperationState getFeedOperationState() {
        return this.operationState;
    }

    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    public CosmosPagedFluxOptions setRequestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
        return this;
    }

    public Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    public CosmosPagedFluxOptions setMaxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        if (this.operationState != null) {
            this.operationState.setMaxItemCount(maxItemCount);
        }
        return this;
    }

    public void setFeedOperationState(FeedOperationState state) {
        this.operationState = Preconditions.checkNotNull(state, "Argument 'state' must not be NULL.");
    }

    public double getSamplingRateSnapshot() {
        FeedOperationState stateSnapshot = this.operationState;
        if (stateSnapshot == null) {
            return 0.0;
        }
        Double samplingRateSnapshot = stateSnapshot.getSamplingRateSnapshot();
        if (samplingRateSnapshot == null) {
            return 0.0;
        }
        return samplingRateSnapshot;
    }

    public void setSamplingRateSnapshot(double samplingRateSnapshot, boolean isSampledOut) {
        if (this.operationState != null) {
            this.operationState.setSamplingRateSnapshot(samplingRateSnapshot, isSampledOut);
        }
    }
}

