/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class InternalObjectNode
extends Resource {
    private static final ObjectMapper MAPPER = Utils.getSimpleObjectMapper();

    public InternalObjectNode() {
    }

    public InternalObjectNode(byte[] bytes) {
        super(bytes);
    }

    public InternalObjectNode(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    public InternalObjectNode setId(String id) {
        super.setId(id);
        return this;
    }

    public InternalObjectNode(String jsonString) {
        super(jsonString);
    }

    public InternalObjectNode(ObjectNode propertyBag) {
        super(propertyBag);
    }

    public static InternalObjectNode fromObjectToInternalObjectNode(Object cosmosItem) {
        if (cosmosItem instanceof InternalObjectNode) {
            return (InternalObjectNode)cosmosItem;
        }
        if (cosmosItem instanceof byte[]) {
            return new InternalObjectNode((byte[])cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new InternalObjectNode((ObjectNode)cosmosItem);
        }
        try {
            return new InternalObjectNode(MAPPER.writeValueAsString(cosmosItem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    public static Document fromObject(Object cosmosItem) {
        if (cosmosItem instanceof InternalObjectNode) {
            return new Document(((InternalObjectNode)cosmosItem).toJson());
        }
        if (cosmosItem instanceof byte[]) {
            return new Document((byte[])cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new Document(new InternalObjectNode((ObjectNode)cosmosItem).toJson());
        }
        try {
            return new Document(MAPPER.writeValueAsString(cosmosItem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    public static ByteBuffer serializeJsonToByteBuffer(Object cosmosItem, ObjectMapper objectMapper, String trackingId) {
        if (cosmosItem instanceof InternalObjectNode) {
            InternalObjectNode internalObjectNode = (InternalObjectNode)cosmosItem;
            if (trackingId != null) {
                internalObjectNode.set("_trackingId", trackingId);
            }
            return internalObjectNode.serializeJsonToByteBuffer();
        }
        if (cosmosItem instanceof Document) {
            Document doc = (Document)cosmosItem;
            if (trackingId != null) {
                doc.set("_trackingId", trackingId);
            }
            return ModelBridgeInternal.serializeJsonToByteBuffer(doc);
        }
        if (cosmosItem instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)cosmosItem;
            if (trackingId != null) {
                objectNode.put("_trackingId", trackingId);
            }
            return new InternalObjectNode(objectNode).serializeJsonToByteBuffer();
        }
        if (cosmosItem instanceof byte[]) {
            if (trackingId != null) {
                InternalObjectNode internalObjectNode = new InternalObjectNode((byte[])cosmosItem);
                internalObjectNode.set("_trackingId", trackingId);
                return internalObjectNode.serializeJsonToByteBuffer();
            }
            return ByteBuffer.wrap((byte[])cosmosItem);
        }
        Object effectivePayload = cosmosItem;
        if (trackingId != null) {
            MapType mapType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Object.class);
            LinkedHashMap node = (LinkedHashMap)objectMapper.convertValue(cosmosItem, (JavaType)mapType);
            node.put("_trackingId", trackingId);
            effectivePayload = node;
        }
        return Utils.serializeJsonToByteBuffer(objectMapper, effectivePayload);
    }

    static <T> List<T> getTypedResultsFromV2Results(List<Document> results, Class<T> klass) {
        return results.stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, klass)).collect(Collectors.toList());
    }

    public <T> T getObject(Class<T> klass) throws IOException {
        if (klass == ObjectNode.class) {
            return (T)this.getPropertyBag();
        }
        return (T)MAPPER.treeToValue((TreeNode)this.getPropertyBag(), klass);
    }
}

