/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.apachecommons.math.random;

import com.azure.cosmos.implementation.apachecommons.math.exception.NotStrictlyPositiveException;
import com.azure.cosmos.implementation.apachecommons.math.random.RandomGenerator;
import java.util.Random;

public class RandomGeneratorFactory {
    private RandomGeneratorFactory() {
    }

    public static RandomGenerator createRandomGenerator(final Random rng) {
        return new RandomGenerator(){

            @Override
            public void setSeed(int seed) {
                rng.setSeed(seed);
            }

            @Override
            public void setSeed(int[] seed) {
                rng.setSeed(RandomGeneratorFactory.convertToLong(seed));
            }

            @Override
            public void setSeed(long seed) {
                rng.setSeed(seed);
            }

            @Override
            public void nextBytes(byte[] bytes) {
                rng.nextBytes(bytes);
            }

            @Override
            public int nextInt() {
                return rng.nextInt();
            }

            @Override
            public int nextInt(int n) {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException(n);
                }
                return rng.nextInt(n);
            }

            @Override
            public long nextLong() {
                return rng.nextLong();
            }

            @Override
            public boolean nextBoolean() {
                return rng.nextBoolean();
            }

            @Override
            public float nextFloat() {
                return rng.nextFloat();
            }

            @Override
            public double nextDouble() {
                return rng.nextDouble();
            }

            @Override
            public double nextGaussian() {
                return rng.nextGaussian();
            }
        };
    }

    public static long convertToLong(int[] seed) {
        long prime = 0xFFFFFFFBL;
        long combined = 0L;
        for (int s : seed) {
            combined = combined * 0xFFFFFFFBL + (long)s;
        }
        return combined;
    }
}

