/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import java.util.EnumSet;
import java.util.Locale;

public enum MetricCategory {
    OperationSummary("OperationSummary", 1),
    OperationDetails("OperationDetails", 2),
    RequestSummary("RequestSummary", 4),
    RequestDetails("RequestDetails", 8),
    AddressResolutions("AddressResolutions", 16),
    DirectChannels("DirectChannels", 32),
    DirectEndpoints("DirectEndpoints", 64),
    DirectRequests("DirectRequests", 128),
    System("System", 256),
    Legacy("Legacy", 512);

    private final int value;
    private final String stringValue;
    private final String toLowerStringValue;
    public static final EnumSet<MetricCategory> ALL_CATEGORIES;
    public static final EnumSet<MetricCategory> DEFAULT_CATEGORIES;
    public static final EnumSet<MetricCategory> MINIMAL_CATEGORIES;

    private MetricCategory(String stringValue, int value) {
        this.stringValue = stringValue;
        this.value = value;
        this.toLowerStringValue = stringValue.toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.stringValue;
    }

    public String toLowerCase() {
        return this.toLowerStringValue;
    }

    public int value() {
        return this.value;
    }

    static {
        ALL_CATEGORIES = EnumSet.allOf(MetricCategory.class);
        DEFAULT_CATEGORIES = EnumSet.of(OperationSummary, RequestSummary, DirectRequests, DirectChannels, System);
        MINIMAL_CATEGORIES = EnumSet.of(OperationSummary, System);
    }
}

