/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdLoop;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdLoopEpoll;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdLoopNIO;
import io.netty.channel.epoll.Epoll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdLoopNativeDetector {
    private static final Logger logger;
    static final RntbdLoop NATIVE_INSTANCE;
    static final RntbdLoop DEFAULT_INSTANCE;

    public static RntbdLoop getRntbdLoop(boolean preferTcpNative) {
        return preferTcpNative ? NATIVE_INSTANCE : DEFAULT_INSTANCE;
    }

    static {
        RntbdLoop nativeLoop;
        logger = LoggerFactory.getLogger(RntbdLoopNativeDetector.class);
        DEFAULT_INSTANCE = new RntbdLoopNIO();
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            nativeLoop = Epoll.isAvailable() ? new RntbdLoopEpoll() : new RntbdLoopNIO();
        }
        catch (Exception e) {
            logger.warn("Failed for native transport checking, will fall back to NIO", (Throwable)e);
            nativeLoop = new RntbdLoopNIO();
        }
        NATIVE_INSTANCE = nativeLoop;
    }
}

