/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.PrimitiveJsonNodeMap;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;

public abstract class CosmosItemSerializer {
    private static final ObjectMapper objectMapper = Utils.getSimpleObjectMapper();
    public static final CosmosItemSerializer DEFAULT_SERIALIZER = new DefaultCosmosItemSerializer();
    private boolean shouldWrapSerializationExceptions;

    protected CosmosItemSerializer() {
        this(true);
    }

    CosmosItemSerializer(boolean shouldWrapSerializationExceptions) {
        this.shouldWrapSerializationExceptions = shouldWrapSerializationExceptions;
    }

    public abstract <T> Map<String, Object> serialize(T var1);

    <T> Map<String, Object> serializeSafe(T item) {
        try {
            return this.serialize(item);
        }
        catch (Throwable throwable) {
            if (!this.shouldWrapSerializationExceptions) {
                throw throwable;
            }
            Exception inner = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            BadRequestException exception = new BadRequestException("Custom serializer '" + this.getClass().getSimpleName() + "' failed to serialize item.", inner);
            BridgeInternal.setSubStatusCode(exception, 10101);
            throw exception;
        }
    }

    public abstract <T> T deserialize(Map<String, Object> var1, Class<T> var2);

    <T> T deserializeSafe(Map<String, Object> jsonNodeMap, Class<T> classType) {
        try {
            return this.deserialize(jsonNodeMap, classType);
        }
        catch (Throwable throwable) {
            if (!this.shouldWrapSerializationExceptions) {
                throw throwable;
            }
            Exception inner = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            BadRequestException exception = new BadRequestException("Custom serializer '" + this.getClass().getSimpleName() + "' failed to deserialize item.", inner);
            BridgeInternal.setSubStatusCode(exception, 10101);
            throw exception;
        }
    }

    void setShouldWrapSerializationExceptions(boolean enabled) {
        this.shouldWrapSerializationExceptions = enabled;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosItemSerializerHelper.setCosmosItemSerializerAccessor(new ImplementationBridgeHelpers.CosmosItemSerializerHelper.CosmosItemSerializerAccessor(){

            @Override
            public <T> Map<String, Object> serializeSafe(CosmosItemSerializer serializer, T item) {
                return serializer.serializeSafe(item);
            }

            @Override
            public <T> T deserializeSafe(CosmosItemSerializer serializer, Map<String, Object> jsonNodeMap, Class<T> classType) {
                return serializer.deserializeSafe(jsonNodeMap, classType);
            }

            @Override
            public void setShouldWrapSerializationExceptions(CosmosItemSerializer serializer, boolean shouldWrapSerializationExceptions) {
                serializer.setShouldWrapSerializationExceptions(shouldWrapSerializationExceptions);
            }
        });
    }

    static {
        CosmosItemSerializer.initialize();
    }

    private static class DefaultCosmosItemSerializer
    extends CosmosItemSerializer {
        DefaultCosmosItemSerializer() {
            super(false);
        }

        @Override
        public <T> Map<String, Object> serialize(T item) {
            if (item == null) {
                return null;
            }
            if (item instanceof ObjectNode) {
                return new ObjectNodeMap((ObjectNode)item);
            }
            if (item instanceof JsonSerializable) {
                return ((JsonSerializable)item).getMap();
            }
            JsonNode jsonNode = (JsonNode)objectMapper.convertValue(item, JsonNode.class);
            if (jsonNode == null) {
                return null;
            }
            if (jsonNode.isObject()) {
                return new ObjectNodeMap((ObjectNode)jsonNode);
            }
            return new PrimitiveJsonNodeMap(jsonNode);
        }

        @Override
        public <T> T deserialize(Map<String, Object> jsonNodeMap, Class<T> classType) {
            if (jsonNodeMap == null) {
                return null;
            }
            ObjectNode jsonNode = null;
            try {
                if (jsonNodeMap instanceof ObjectNodeMap) {
                    jsonNode = ((ObjectNodeMap)jsonNodeMap).getObjectNode();
                } else {
                    if (jsonNodeMap instanceof PrimitiveJsonNodeMap) {
                        return (T)objectMapper.convertValue((Object)((PrimitiveJsonNodeMap)jsonNodeMap).getPrimitiveJsonNode(), classType);
                    }
                    jsonNode = (ObjectNode)objectMapper.convertValue(jsonNodeMap, ObjectNode.class);
                }
                if (JsonSerializable.class.isAssignableFrom(classType)) {
                    return (T)JsonSerializable.instantiateFromObjectNodeAndType(jsonNode, classType);
                }
                return (T)objectMapper.treeToValue((TreeNode)jsonNode, classType);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to parse JSON %s as %s", jsonNode, classType.getName()), e);
            }
        }
    }
}

