/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.credential.SimpleTokenCache;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AadTokenAuthorizationHelper {
    public static final String AAD_AUTH_SCHEMA_TYPE_SEGMENT = "type";
    public static final String AAD_AUTH_VERSION_SEGMENT = "ver";
    public static final String AAD_AUTH_SIGNATURE_SEGMENT = "sig";
    public static final String AAD_AUTH_SCHEMA_TYPE_VALUE = "aad";
    public static final String AAD_AUTH_VERSION_VALUE = "1.0";
    public static final String AAD_AUTH_TOKEN_COSMOS_SCOPE = "https://cosmos.azure.com/.default";
    private static final String AUTH_PREFIX = "type=aad&ver=1.0&sig=";
    private static final Logger logger = LoggerFactory.getLogger(AadTokenAuthorizationHelper.class);

    public static Mono<RxDocumentServiceRequest> populateAuthorizationHeader(RxDocumentServiceRequest request, SimpleTokenCache simpleTokenCache) {
        if (request == null || request.getHeaders() == null) {
            throw new IllegalArgumentException("request");
        }
        if (simpleTokenCache == null) {
            throw new IllegalArgumentException("simpleTokenCache");
        }
        return AadTokenAuthorizationHelper.getAuthorizationToken(simpleTokenCache).map(authorization -> {
            request.getHeaders().put("authorization", (String)authorization);
            return request;
        });
    }

    public static Mono<String> getAuthorizationToken(SimpleTokenCache simpleTokenCache) {
        return simpleTokenCache.getToken().map(accessToken -> {
            String authorization;
            String authorizationPayload = AUTH_PREFIX + accessToken.getToken();
            try {
                authorization = URLEncoder.encode(authorizationPayload, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authorization token.", e);
            }
            return authorization;
        });
    }
}

