/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.OfferAutoscaleSettings;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Offer
extends Resource {
    public Offer(int offerThroughput) {
        this.setOfferVersion("V2");
        this.setOfferType("");
        ObjectNode content = Utils.getSimpleObjectMapper().createObjectNode();
        content.put("offerThroughput", offerThroughput);
        this.setContent(content);
    }

    Offer(OfferAutoscaleSettings offerAutoscaleSettings) {
        this.setOfferVersion("V2");
        this.setOfferType("");
        ObjectNode content = Utils.getSimpleObjectMapper().createObjectNode();
        content.replace("offerAutopilotSettings", (JsonNode)offerAutoscaleSettings.getPropertyBag());
        this.setContent(content);
    }

    public Offer(String jsonString) {
        super(jsonString);
    }

    public Offer(ObjectNode objectNode) {
        super(objectNode);
    }

    public static Offer createManualOffer(int throughput) {
        return new Offer(throughput);
    }

    public static Offer createAutoscaleOffer(int startingMaxThroughput, int autoUpgradeMaxThroughputIncrementPercentage) {
        return new Offer(new OfferAutoscaleSettings(startingMaxThroughput, autoUpgradeMaxThroughputIncrementPercentage));
    }

    public OfferAutoscaleSettings getOfferAutoScaleSettings() {
        if (this.getContent().hasNonNull("offerAutopilotSettings")) {
            return new OfferAutoscaleSettings((ObjectNode)this.getContent().get("offerAutopilotSettings"));
        }
        return null;
    }

    public int getAutoscaleMaxThroughput() {
        OfferAutoscaleSettings offerAutoscaleSettings = this.getOfferAutoScaleSettings();
        if (offerAutoscaleSettings != null) {
            return offerAutoscaleSettings.getMaxThroughput();
        }
        return 0;
    }

    public void setAutoscaleMaxThroughput(int autoscaleMaxThroughput) {
        OfferAutoscaleSettings offerAutoscaleSettings = this.getOfferAutoScaleSettings();
        if (offerAutoscaleSettings != null) {
            offerAutoscaleSettings.setMaxThroughput(autoscaleMaxThroughput);
        }
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    void setResourceLink(String resourceLink) {
        this.set("resource", resourceLink, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public String getOfferResourceId() {
        return super.getString("offerResourceId");
    }

    void setOfferResourceId(String resourceId) {
        this.set("offerResourceId", resourceId, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public String getOfferType() {
        return super.getString("offerType");
    }

    public void setOfferType(String offerType) {
        this.set("offerType", offerType, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public String getOfferVersion() {
        return super.getString("offerVersion");
    }

    public void setOfferVersion(String offerVersion) {
        this.set("offerVersion", offerVersion, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    public int getThroughput() {
        return this.getContent().get("offerThroughput").asInt();
    }

    public boolean hasOfferThroughput() {
        return this.getContent().hasNonNull("offerThroughput");
    }

    public void setThroughput(int throughput) {
        this.getContent().put("offerThroughput", throughput);
    }

    private ObjectNode getContent() {
        return this.getObject("content");
    }

    private void setContent(ObjectNode offerContent) {
        this.set("content", offerContent, CosmosItemSerializer.DEFAULT_SERIALIZER);
    }

    @Override
    public String getString(String propertyName) {
        return super.getString(propertyName);
    }

    @Override
    public Integer getInt(String propertyName) {
        return super.getInt(propertyName);
    }

    public void updateAutoscaleThroughput(int maxAutoscaleThroughput) {
        this.getOfferAutoScaleSettings().setMaxThroughput(maxAutoscaleThroughput);
    }

    public void updateContent(Offer offer) {
        this.setContent(offer.getContent());
    }
}

